/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.export;

import jadx.core.export.ExportGradle;
import jadx.core.export.ExportGradleType;
import jadx.core.utils.files.FileUtils;
import jadx.gui.JadxWrapper;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.CommonDialog;
import jadx.gui.ui.export.ExportProjectProperties;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportProjectDialog
extends CommonDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ExportProjectDialog.class);
    private final ExportProjectProperties exportProjectProperties = new ExportProjectProperties();
    private final Consumer<ExportProjectProperties> exportListener;

    public ExportProjectDialog(MainWindow mainWindow, Consumer<ExportProjectProperties> exportListener) {
        super(mainWindow);
        this.exportListener = exportListener;
        this.initUI();
    }

    private void initUI() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)this.makeContentPane(), "First");
        contentPanel.add((Component)this.initButtonsPanel(), "Last");
        this.getContentPane().add(contentPanel);
        this.setTitle(NLS.str("export_dialog.title"));
        this.commonWindowInit();
    }

    private JPanel makeContentPane() {
        JLabel pathLbl = new JLabel(NLS.str("export_dialog.save_path"));
        JTextField pathField = new JTextField();
        pathField.getDocument().addDocumentListener(new DocumentUpdateListener(ev4 -> this.setExportProjectPath(pathField)));
        pathField.setText(this.mainWindow.getSettings().getLastSaveFilePath().toString());
        TextStandardActions.attach(pathField);
        JButton browseButton = this.makeEditorBrowseButton(pathField);
        JCheckBox resourceDecode = new JCheckBox(NLS.str("preferences.skipResourcesDecode"));
        resourceDecode.setSelected(this.mainWindow.getSettings().isSkipResources());
        resourceDecode.addItemListener(e15 -> this.exportProjectProperties.setSkipResources(e15.getStateChange() == 1));
        JCheckBox skipSources = new JCheckBox(NLS.str("preferences.skipSourcesDecode"));
        skipSources.setSelected(this.mainWindow.getSettings().isSkipSources());
        skipSources.addItemListener(e15 -> this.exportProjectProperties.setSkipSources(e15.getStateChange() == 1));
        JLabel exportTypeLbl = new JLabel(NLS.str("export_dialog.export_gradle_type"));
        JComboBox<ExportGradleType> exportTypeComboBox = new JComboBox<ExportGradleType>(ExportGradleType.values());
        exportTypeLbl.setLabelFor(exportTypeComboBox);
        ExportGradleType initialExportType = this.getExportGradleType();
        this.exportProjectProperties.setExportGradleType(initialExportType);
        exportTypeComboBox.setSelectedItem((Object)initialExportType);
        exportTypeComboBox.addItemListener(e15 -> this.exportProjectProperties.setExportGradleType((ExportGradleType)((Object)((Object)e15.getItem()))));
        exportTypeComboBox.setEnabled(false);
        JCheckBox exportAsGradleProject = new JCheckBox(NLS.str("export_dialog.export_gradle"));
        exportAsGradleProject.addItemListener(e15 -> {
            boolean enableGradle = e15.getStateChange() == 1;
            this.exportProjectProperties.setAsGradleMode(enableGradle);
            exportTypeComboBox.setEnabled(enableGradle);
            resourceDecode.setEnabled(!enableGradle);
            skipSources.setEnabled(!enableGradle);
        });
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BoxLayout(pathPanel, 2));
        pathPanel.setAlignmentX(0.0f);
        pathPanel.add(pathLbl);
        pathPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        pathPanel.add(pathField);
        pathPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        pathPanel.add(browseButton);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 2));
        typePanel.setAlignmentX(0.0f);
        typePanel.add(Box.createRigidArea(new Dimension(20, 0)));
        typePanel.add(exportTypeLbl);
        typePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        typePanel.add(exportTypeComboBox);
        typePanel.add(Box.createHorizontalGlue());
        JPanel exportOptionsPanel = new JPanel();
        exportOptionsPanel.setBorder(BorderFactory.createTitledBorder(NLS.str("export_dialog.export_options")));
        exportOptionsPanel.setLayout(new BoxLayout(exportOptionsPanel, 3));
        exportOptionsPanel.add(exportAsGradleProject);
        exportOptionsPanel.add(typePanel);
        exportOptionsPanel.add(resourceDecode);
        exportOptionsPanel.add(skipSources);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(pathPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        mainPanel.add(exportOptionsPanel);
        return mainPanel;
    }

    private ExportGradleType getExportGradleType() {
        try {
            JadxWrapper wrapper = this.mainWindow.getWrapper();
            return ExportGradle.detectExportType(wrapper.getRootNode(), wrapper.getResources());
        }
        catch (Exception e15) {
            LOG.warn("Failed to detect export type", e15);
            return ExportGradleType.AUTO;
        }
    }

    private void setExportProjectPath(JTextField field) {
        String path = field.getText();
        if (!path.isEmpty()) {
            this.exportProjectProperties.setExportPath(field.getText());
        }
    }

    protected JPanel initButtonsPanel() {
        JButton cancelButton = new JButton(NLS.str("common_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        JButton exportProjectButton = new JButton(NLS.str("common_dialog.ok"));
        exportProjectButton.addActionListener(event -> this.exportProject());
        this.getRootPane().setDefaultButton(exportProjectButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(exportProjectButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    private JButton makeEditorBrowseButton(JTextField textField) {
        JButton button = new JButton(NLS.str("export_dialog.browse"));
        button.addActionListener(e15 -> {
            FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.EXPORT);
            this.mainWindow.getSettings().setLastSaveFilePath(fileDialog.getCurrentDir());
            List<Path> saveDirs = fileDialog.show();
            if (saveDirs.isEmpty()) {
                return;
            }
            String path = saveDirs.get(0).toString();
            textField.setText(path);
        });
        return button;
    }

    private void exportProject() {
        String exportPathStr = this.exportProjectProperties.getExportPath();
        if (!ExportProjectDialog.validateAndMakeDir(exportPathStr)) {
            JOptionPane.showMessageDialog(this, NLS.str("message.enter_valid_path"), NLS.str("message.errorTitle"), 2);
            return;
        }
        this.mainWindow.getSettings().setLastSaveFilePath(Path.of(exportPathStr, new String[0]));
        LOG.debug("Export properties: {}", (Object)this.exportProjectProperties);
        this.exportListener.accept(this.exportProjectProperties);
        this.dispose();
    }

    private static boolean validateAndMakeDir(String exportPath) {
        if (exportPath == null || exportPath.isBlank()) {
            return false;
        }
        try {
            Path path = Path.of(exportPath, new String[0]);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return false;
            }
            FileUtils.makeDirs(path);
            return true;
        }
        catch (Exception e15) {
            LOG.warn("Export path validate error, path string:{}", (Object)exportPath, (Object)e15);
            return false;
        }
    }
}

