/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.ICodeComment;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeComment;
import jadx.api.data.impl.JadxCodeData;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.gui.JadxWrapper;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.CodeAreaAction;
import jadx.gui.ui.action.JadxGuiAction;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.dialog.CommentDialog;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.event.PopupMenuEvent;
import org.fife.ui.rsyntaxtextarea.Token;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentAction
extends CodeAreaAction
implements DefaultPopupMenuListener {
    private static final long serialVersionUID = 4753838562204629112L;
    private static final Logger LOG = LoggerFactory.getLogger(CommentAction.class);
    private final boolean enabled;
    @Nullable
    private ICodeComment actionComment;
    private boolean updateComment;

    public CommentAction(CodeArea codeArea) {
        super(ActionModel.CODE_COMMENT, codeArea);
        this.enabled = codeArea.getNode() instanceof JClass;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e15) {
        if (this.enabled && this.updateCommentAction(UiUtils.getOffsetAtMousePosition(this.codeArea))) {
            this.setNameAndDesc(this.updateComment ? NLS.str("popup.update_comment") : NLS.str("popup.add_comment"));
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e15) {
        this.actionComment = null;
        this.setEnabled(false);
    }

    private boolean updateCommentAction(int pos) {
        ICodeComment codeComment = this.getCommentRef(pos);
        if (codeComment == null) {
            this.actionComment = null;
            return false;
        }
        ICodeComment exitsComment = this.searchForExistComment(codeComment);
        if (exitsComment != null) {
            this.actionComment = exitsComment;
            this.updateComment = true;
        } else {
            this.actionComment = codeComment;
            this.updateComment = false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e15) {
        if (!this.enabled) {
            return;
        }
        if (JadxGuiAction.isSource(e15)) {
            this.updateCommentAction(this.codeArea.getCaretPosition());
        }
        if (this.actionComment == null) {
            UiUtils.showMessageBox(this.codeArea.getMainWindow(), NLS.str("msg.cant_add_comment"));
            return;
        }
        CommentDialog.show(this.codeArea, this.actionComment, this.updateComment);
    }

    @Nullable
    private ICodeComment searchForExistComment(ICodeComment blankComment) {
        try {
            JadxProject project = this.codeArea.getProject();
            JadxCodeData codeData = project.getCodeData();
            if (codeData == null || codeData.getComments().isEmpty()) {
                return null;
            }
            for (ICodeComment comment : codeData.getComments()) {
                if (!Objects.equals(comment.getNodeRef(), blankComment.getNodeRef()) || !Objects.equals(comment.getCodeRef(), blankComment.getCodeRef())) continue;
                return comment;
            }
        }
        catch (Exception e15) {
            LOG.error("Error searching for exists comment", e15);
        }
        return null;
    }

    @Nullable
    private ICodeComment getCommentRef(int pos) {
        if (pos == -1) {
            return null;
        }
        try {
            ICodeNodeRef nodeRef;
            JavaNode node;
            JadxWrapper wrapper = this.codeArea.getJadxWrapper();
            ICodeInfo codeInfo = this.codeArea.getCodeInfo();
            ICodeMetadata metadata = codeInfo.getCodeMetadata();
            int lineStartPos = this.codeArea.getLineStartFor(pos);
            ICodeAnnotation offsetAnn = metadata.searchUp(pos, lineStartPos, ICodeAnnotation.AnnType.OFFSET);
            if (offsetAnn instanceof InsnCodeOffset && (node = wrapper.getJavaNodeByRef(metadata.getNodeAt(pos))) instanceof JavaMethod) {
                int rawOffset = ((InsnCodeOffset)offsetAnn).getOffset();
                JadxNodeRef nodeRef2 = JadxNodeRef.forMth((JavaMethod)node);
                return new JadxCodeComment((IJavaNodeRef)nodeRef2, JadxCodeRef.forInsn(rawOffset), "");
            }
            ICodeNodeRef nodeDef = metadata.searchUp(pos, (off, ann) -> {
                ICodeNodeRef defRef;
                if (lineStartPos <= off && ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION && (defRef = ((NodeDeclareRef)ann).getNode()).getAnnType() != ICodeAnnotation.AnnType.VAR) {
                    return defRef;
                }
                return null;
            });
            if (nodeDef != null) {
                JadxNodeRef nodeRef3 = JadxNodeRef.forJavaNode(wrapper.getJavaNodeByRef(nodeDef));
                return new JadxCodeComment(nodeRef3, "");
            }
            if (this.isCommentLine(pos) && (nodeRef = metadata.searchDown(pos, (off, ann) -> {
                if (off > pos && ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION) {
                    return ((NodeDeclareRef)ann).getNode();
                }
                return null;
            })) != null) {
                JavaNode defNode = wrapper.getJavaNodeByRef(nodeRef);
                return new JadxCodeComment(JadxNodeRef.forJavaNode(defNode), "");
            }
        }
        catch (Exception e15) {
            LOG.error("Failed to add comment at: {}", (Object)pos, (Object)e15);
        }
        return null;
    }

    private boolean isCommentLine(int pos) {
        try {
            int line = this.codeArea.getLineOfOffset(pos);
            Token lineTokens = this.codeArea.getTokenListForLine(line);
            boolean commentFound = false;
            block5: for (Token t15 = lineTokens; t15 != null; t15 = t15.getNextToken()) {
                if (t15.isComment()) {
                    commentFound = true;
                    continue;
                }
                switch (t15.getType()) {
                    case 0: 
                    case 21: {
                        continue block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return commentFound;
        }
        catch (Exception e15) {
            LOG.warn("Failed to check for comment line", e15);
            return false;
        }
    }
}

