/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search;

import jadx.gui.search.ISearchProvider;
import jadx.gui.search.SearchTask;
import jadx.gui.treemodel.JNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchJob
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SearchJob.class);
    private final SearchTask searchTask;
    private final ISearchProvider provider;

    public SearchJob(SearchTask task, ISearchProvider provider) {
        this.searchTask = task;
        this.provider = provider;
    }

    @Override
    public void run() {
        try {
            JNode result;
            do {
                if ((result = this.provider.next(this.searchTask)) != null) continue;
                return;
            } while (!this.searchTask.addResult(result));
            return;
        }
        catch (Exception e15) {
            LOG.warn("Search error, provider: {}", (Object)this.provider.getClass().getSimpleName(), (Object)e15);
            return;
        }
    }

    public ISearchProvider getProvider() {
        return this.provider;
    }
}

