/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.utils.tasks.ITaskExecutor;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.TaskStatus;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class InternalTask
implements Delayed,
ITaskInfo {
    private final long id;
    private final IBackgroundTask bgTask;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicLong nextUpdate = new AtomicLong(0L);
    private final AtomicBoolean firstUpdate = new AtomicBoolean(true);
    private long startTime;
    private long execTime;
    private Supplier<TaskStatus> cancelCheck;
    private TaskStatus status = TaskStatus.WAIT;
    private ITaskExecutor taskExecutor;
    private long jobsCount;
    private long jobsComplete;

    public InternalTask(long id5, IBackgroundTask task) {
        this.id = id5;
        this.bgTask = task;
    }

    public void taskStart(long startTime, Supplier<TaskStatus> cancelCheck) {
        this.startTime = startTime;
        this.cancelCheck = cancelCheck;
        this.status = TaskStatus.STARTED;
        this.running.set(true);
    }

    public void taskComplete() {
        this.running.set(false);
        if (this.status == TaskStatus.STARTED) {
            this.status = TaskStatus.COMPLETE;
        }
        this.updateExecTime();
    }

    public long getId() {
        return this.id;
    }

    public IBackgroundTask getBgTask() {
        return this.bgTask;
    }

    public void setNextUpdate(long nextUpdate) {
        this.nextUpdate.set(nextUpdate);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean checkForFirstUpdate() {
        return this.firstUpdate.compareAndExchange(true, false);
    }

    public Supplier<TaskStatus> getCancelCheck() {
        return this.cancelCheck;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus taskStatus) {
        this.status = taskStatus;
    }

    public ITaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(ITaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public long getJobsComplete() {
        return this.jobsComplete;
    }

    public void setJobsComplete(long jobsComplete) {
        this.jobsComplete = jobsComplete;
    }

    @Override
    public long getJobsCount() {
        return this.jobsCount;
    }

    public void setJobsCount(long jobsCount) {
        this.jobsCount = jobsCount;
    }

    @Override
    public long getJobsSkipped() {
        return this.jobsCount - this.jobsComplete;
    }

    @Override
    public long getTime() {
        return this.execTime;
    }

    public void updateExecTime() {
        this.execTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        return unit.convert(this.nextUpdate.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@NotNull Delayed o15) {
        return Long.compare(this.nextUpdate.get(), ((InternalTask)o15).nextUpdate.get());
    }

    public String toString() {
        return "InternalTask{" + this.bgTask.getTitle() + ", status=" + String.valueOf((Object)this.status) + ", progress=" + this.jobsComplete + " of " + this.jobsCount + "}";
    }
}

