/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.usage;

import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.gui.cache.usage.ClsUsageData;
import jadx.gui.cache.usage.FldRef;
import jadx.gui.cache.usage.FldUsageData;
import jadx.gui.cache.usage.MthRef;
import jadx.gui.cache.usage.MthUsageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class RawUsageData {
    private final Map<String, ClsUsageData> clsMap = new HashMap<String, ClsUsageData>();
    private List<String> classesWithoutData = Collections.emptyList();

    RawUsageData() {
    }

    public Map<String, ClsUsageData> getClsMap() {
        return this.clsMap;
    }

    public List<String> getClassesWithoutData() {
        return this.classesWithoutData;
    }

    public ClsUsageData getClassData(ClassNode cls) {
        return this.getClassData(cls.getRawName());
    }

    public ClsUsageData getClassData(String clsRawName) {
        return this.clsMap.computeIfAbsent(clsRawName, ClsUsageData::new);
    }

    public MthUsageData getMethodData(MethodNode mth) {
        ClassNode parentClass = mth.getParentClass();
        String shortId = mth.getMethodInfo().getShortId();
        return this.getClassData(parentClass).getMthUsage().computeIfAbsent(shortId, m15 -> new MthUsageData(new MthRef(parentClass.getRawName(), shortId)));
    }

    public FldUsageData getFieldData(FieldNode fld) {
        ClassNode parentClass = fld.getParentClass();
        String shortId = fld.getFieldInfo().getShortId();
        return this.getClassData(parentClass).getFldUsage().computeIfAbsent(shortId, m15 -> new FldUsageData(new FldRef(parentClass.getRawName(), shortId)));
    }

    public void collectClassesWithoutData() {
        HashSet<String> allClasses = new HashSet<String>(this.clsMap.size() * 2);
        for (ClsUsageData usageData : this.clsMap.values()) {
            List<String> usage;
            List<String> deps = usageData.getClsDeps();
            if (deps != null) {
                allClasses.addAll(deps);
            }
            if ((usage = usageData.getClsUsage()) == null) continue;
            allClasses.addAll(usage);
        }
        allClasses.removeAll(this.clsMap.keySet());
        this.classesWithoutData = new ArrayList<String>(allClasses);
        Collections.sort(this.classesWithoutData);
    }
}

