/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code.disk;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import java.io.IOException;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferCodeCache
implements ICodeCache {
    private static final int BUFFER_SIZE = 20;
    private final ICodeCache backCache;
    private final Map<String, ICodeInfo> cache = new ConcurrentHashMap<String, ICodeInfo>();
    private final Deque<String> buffer = new ConcurrentLinkedDeque<String>();

    public BufferCodeCache(ICodeCache backCache) {
        this.backCache = backCache;
    }

    private void addInternal(String clsFullName, ICodeInfo codeInfo) {
        this.cache.put(clsFullName, codeInfo);
        this.buffer.addLast(clsFullName);
        if (this.buffer.size() > 20) {
            String removedKey = this.buffer.removeFirst();
            this.cache.remove(removedKey);
        }
    }

    @Override
    public boolean contains(String clsFullName) {
        if (this.cache.containsKey(clsFullName)) {
            return true;
        }
        return this.backCache.contains(clsFullName);
    }

    @Override
    public void add(String clsFullName, ICodeInfo codeInfo) {
        this.addInternal(clsFullName, codeInfo);
        this.backCache.add(clsFullName, codeInfo);
    }

    @Override
    @NotNull
    public ICodeInfo get(String clsFullName) {
        ICodeInfo codeInfo = this.cache.get(clsFullName);
        if (codeInfo != null) {
            return codeInfo;
        }
        ICodeInfo backCodeInfo = this.backCache.get(clsFullName);
        if (backCodeInfo != ICodeInfo.EMPTY) {
            this.addInternal(clsFullName, backCodeInfo);
        }
        return backCodeInfo;
    }

    @Override
    @Nullable
    public String getCode(String clsFullName) {
        ICodeInfo codeInfo = this.cache.get(clsFullName);
        if (codeInfo != null) {
            return codeInfo.getCodeStr();
        }
        return this.backCache.getCode(clsFullName);
    }

    @Override
    public void remove(String clsFullName) {
        this.cache.remove(clsFullName);
        this.backCache.remove(clsFullName);
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
        this.buffer.clear();
        this.backCache.close();
    }
}

