/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.args.Typed;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsnArg
extends Typed {
    private static final Logger LOG = LoggerFactory.getLogger(InsnArg.class);
    @Nullable(value="Null for method arguments")
    protected @Nullable(value="Null for method arguments") InsnNode parentInsn;

    public static RegisterArg reg(int regNum, ArgType type) {
        return new RegisterArg(regNum, type);
    }

    public static RegisterArg reg(InsnData insn, int argNum, ArgType type) {
        return InsnArg.reg(insn.getReg(argNum), type);
    }

    public static RegisterArg typeImmutableIfKnownReg(InsnData insn, int argNum, ArgType type) {
        if (type.isTypeKnown()) {
            return InsnArg.typeImmutableReg(insn.getReg(argNum), type);
        }
        return InsnArg.reg(insn.getReg(argNum), type);
    }

    public static RegisterArg typeImmutableReg(InsnData insn, int argNum, ArgType type) {
        return InsnArg.typeImmutableReg(insn.getReg(argNum), type);
    }

    public static RegisterArg typeImmutableReg(int regNum, ArgType type) {
        return InsnArg.reg(regNum, type, true);
    }

    public static RegisterArg reg(int regNum, ArgType type, boolean typeImmutable) {
        RegisterArg reg = new RegisterArg(regNum, type);
        if (typeImmutable) {
            reg.add(AFlag.IMMUTABLE_TYPE);
        }
        return reg;
    }

    public static LiteralArg lit(long literal, ArgType type) {
        return LiteralArg.makeWithFixedType(literal, type);
    }

    public static LiteralArg lit(InsnData insn, ArgType type) {
        return InsnArg.lit(insn.getLiteral(), type);
    }

    private static InsnWrapArg wrap(InsnNode insn) {
        insn.add(AFlag.WRAPPED);
        return new InsnWrapArg(insn);
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isInsnWrap() {
        return false;
    }

    public boolean isNamed() {
        return false;
    }

    @Nullable
    public InsnNode getParentInsn() {
        return this.parentInsn;
    }

    public void setParentInsn(@Nullable InsnNode parentInsn) {
        this.parentInsn = parentInsn;
    }

    @Nullable(value="if wrap failed")
    public @Nullable(value="if wrap failed") InsnArg wrapInstruction(MethodNode mth, InsnNode insn) {
        return this.wrapInstruction(mth, insn, true);
    }

    @Nullable(value="if wrap failed")
    public @Nullable(value="if wrap failed") InsnArg wrapInstruction(MethodNode mth, InsnNode insn, boolean unbind) {
        String name;
        InsnNode parent = this.parentInsn;
        if (parent == null) {
            return null;
        }
        if (parent == insn) {
            LOG.debug("Can't wrap instruction info itself: {}", (Object)insn);
            return null;
        }
        int i15 = InsnArg.getArgIndex(parent, this);
        if (i15 == -1) {
            return null;
        }
        if (insn.getType() == InsnType.MOVE && this.isRegister() && (name = ((RegisterArg)this).getName()) != null) {
            InsnNode wrapInsn;
            RegisterArg registerArg;
            InsnArg arg = insn.getArg(0);
            if (arg.isRegister()) {
                ((RegisterArg)arg).setNameIfUnknown(name);
            } else if (arg.isInsnWrap() && (registerArg = (wrapInsn = ((InsnWrapArg)arg).getWrapInsn()).getResult()) != null) {
                registerArg.setNameIfUnknown(name);
            }
        }
        InsnArg arg = InsnArg.wrapInsnIntoArg(insn);
        InsnArg oldArg = parent.getArg(i15);
        if (arg.getType() == ArgType.UNKNOWN) {
            arg.setType(oldArg.getType());
        }
        parent.setArg(i15, arg);
        InsnRemover.unbindArgUsage(mth, oldArg);
        if (unbind) {
            InsnRemover.unbindArgUsage(mth, this);
            InsnRemover.unbindResult(mth, insn);
            insn.setResult(null);
        }
        return arg;
    }

    private static int getArgIndex(InsnNode parent, InsnArg arg) {
        int count = parent.getArgsCount();
        for (int i15 = 0; i15 < count; ++i15) {
            if (parent.getArg(i15) != arg) continue;
            return i15;
        }
        return -1;
    }

    @NotNull
    public static InsnArg wrapInsnIntoArg(InsnNode insn) {
        InsnType type = insn.getType();
        if (type == InsnType.CONST || type == InsnType.MOVE) {
            if (insn.contains(AFlag.FORCE_ASSIGN_INLINE)) {
                RegisterArg resArg = insn.getResult();
                InsnWrapArg arg = InsnArg.wrap(insn);
                if (resArg != null) {
                    arg.setType(resArg.getType());
                }
                return arg;
            }
            InsnArg arg = insn.getArg(0);
            insn.add(AFlag.DONT_GENERATE);
            return arg;
        }
        return InsnArg.wrapArg(insn);
    }

    public static InsnArg wrapArg(InsnNode insn) {
        RegisterArg resArg = insn.getResult();
        InsnWrapArg arg = InsnArg.wrap(insn);
        switch (insn.getType()) {
            case CONST: 
            case MOVE: {
                throw new JadxRuntimeException("Don't wrap MOVE or CONST insns: " + String.valueOf(insn));
            }
            case CONST_STR: {
                arg.setType(ArgType.STRING);
                if (resArg == null) break;
                resArg.setType(ArgType.STRING);
                break;
            }
            case CONST_CLASS: {
                arg.setType(ArgType.CLASS);
                if (resArg == null) break;
                resArg.setType(ArgType.CLASS);
                break;
            }
            default: {
                if (resArg == null) break;
                arg.setType(resArg.getType());
            }
        }
        return arg;
    }

    public boolean isZeroLiteral() {
        return false;
    }

    public boolean isZeroConst() {
        InsnNode wrapInsn;
        if (this.isZeroLiteral()) {
            return true;
        }
        if (this.isInsnWrap() && (wrapInsn = ((InsnWrapArg)this).getWrapInsn()).getType() == InsnType.CONST) {
            return wrapInsn.getArg(0).isZeroLiteral();
        }
        return false;
    }

    public boolean isFalse() {
        if (this.isLiteral()) {
            LiteralArg litArg = (LiteralArg)this;
            return litArg.getLiteral() == 0L && Objects.equals(litArg.getType(), ArgType.BOOLEAN);
        }
        return false;
    }

    public boolean isTrue() {
        if (this.isLiteral()) {
            LiteralArg litArg = (LiteralArg)this;
            return litArg.getLiteral() == 1L && Objects.equals(litArg.getType(), ArgType.BOOLEAN);
        }
        return false;
    }

    public boolean isThis() {
        return this.contains(AFlag.THIS);
    }

    public boolean isAnyThis() {
        if (this.contains(AFlag.THIS)) {
            return true;
        }
        InsnNode wrappedInsn = this.unwrap();
        if (wrappedInsn != null && wrappedInsn.getType() == InsnType.IGET) {
            return wrappedInsn.getArg(0).isAnyThis();
        }
        return false;
    }

    public InsnNode unwrap() {
        if (this.isInsnWrap()) {
            return ((InsnWrapArg)this).getWrapInsn();
        }
        return null;
    }

    public boolean isConst() {
        return this.isLiteral() || this.isInsnWrap() && ((InsnWrapArg)this).getWrapInsn().isConstInsn();
    }

    public boolean isSameConst(InsnArg other) {
        if (this.isConst() && other.isConst()) {
            return this.equals(other);
        }
        return false;
    }

    public boolean isSameVar(RegisterArg arg) {
        if (arg == null) {
            return false;
        }
        if (this.isRegister()) {
            return ((RegisterArg)this).sameRegAndSVar(arg);
        }
        return false;
    }

    public boolean isSameVar(SSAVar ssaVar) {
        if (ssaVar == null) {
            return false;
        }
        if (this.isRegister()) {
            SSAVar thisSsaVar = ((RegisterArg)this).getSVar();
            return Objects.equals(thisSsaVar, ssaVar);
        }
        return false;
    }

    public boolean isSameCodeVar(RegisterArg arg) {
        if (arg == null) {
            return false;
        }
        if (this.isRegister()) {
            return ((RegisterArg)this).sameCodeVar(arg);
        }
        return false;
    }

    public boolean isUseVar(RegisterArg arg) {
        return InsnUtils.containsVar(this, arg);
    }

    protected final <T extends InsnArg> T copyCommonParams(T copy) {
        copy.copyAttributesFrom(this);
        copy.setParentInsn(this.parentInsn);
        return copy;
    }

    public InsnArg duplicate() {
        return this;
    }

    public String toShortString() {
        return this.toString();
    }
}

