/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.api.CommentsLevel;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.utils.Utils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JadxCommentsAttr
implements IJadxAttribute {
    private final Map<CommentsLevel, Set<String>> comments = new EnumMap<CommentsLevel, Set<String>>(CommentsLevel.class);

    public static void add(IAttributeNode node, CommentsLevel level, String comment) {
        JadxCommentsAttr.initFor(node).add(level, comment);
    }

    private static JadxCommentsAttr initFor(IAttributeNode node) {
        JadxCommentsAttr currentAttr = node.get(AType.JADX_COMMENTS);
        if (currentAttr != null) {
            return currentAttr;
        }
        JadxCommentsAttr newAttr = new JadxCommentsAttr();
        node.addAttr(newAttr);
        return newAttr;
    }

    public void add(CommentsLevel level, String comment) {
        this.comments.computeIfAbsent(level, l15 -> new HashSet()).add(comment);
    }

    public List<String> formatAndFilter(CommentsLevel level) {
        if (level == CommentsLevel.NONE || level == CommentsLevel.USER_ONLY) {
            return Collections.emptyList();
        }
        return this.comments.entrySet().stream().filter(e15 -> ((CommentsLevel)((Object)((Object)e15.getKey()))).filter(level)).flatMap(e15 -> {
            String levelName = ((CommentsLevel)((Object)((Object)e15.getKey()))).name();
            return ((Set)e15.getValue()).stream().map(v15 -> "JADX " + levelName + ": " + v15);
        }).sorted().collect(Collectors.toList());
    }

    public Map<CommentsLevel, Set<String>> getComments() {
        return this.comments;
    }

    public IJadxAttrType<JadxCommentsAttr> getAttrType() {
        return AType.JADX_COMMENTS;
    }

    public String toString() {
        return "JadxCommentsAttr{\n " + Utils.listToString(this.comments.entrySet(), "\n ", e15 -> String.valueOf(e15.getKey()) + ": \n -> " + Utils.listToString((Iterable)e15.getValue(), "\n -> ")) + "}";
    }
}

