/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.options.impl;

import jadx.api.plugins.options.OptionDescription;
import jadx.api.plugins.options.OptionFlag;
import jadx.api.plugins.options.OptionType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JadxOptionDescription
implements OptionDescription {
    private final String name;
    private final String desc;
    private final String defaultValue;
    private final List<String> values;
    private final OptionType type;
    private final Set<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);

    public static JadxOptionDescription booleanOption(String name, String desc, boolean defaultValue) {
        return new JadxOptionDescription(name, desc, defaultValue ? "yes" : "no", Arrays.asList("yes", "no"), OptionType.BOOLEAN);
    }

    public JadxOptionDescription(String name, String desc, @Nullable String defaultValue, List<String> values2) {
        this(name, desc, defaultValue, values2, OptionType.STRING);
    }

    public JadxOptionDescription(String name, String desc, @Nullable String defaultValue, List<String> values2, OptionType type) {
        this.name = name;
        this.desc = desc;
        this.defaultValue = defaultValue;
        this.values = values2;
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.desc;
    }

    @Override
    @Nullable
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<String> values() {
        return this.values;
    }

    @Override
    public OptionType getType() {
        return this.type;
    }

    @Override
    public Set<OptionFlag> getFlags() {
        return this.flags;
    }

    public JadxOptionDescription withFlag(OptionFlag flag) {
        this.flags.add(flag);
        return this;
    }

    public JadxOptionDescription withFlags(OptionFlag ... flags) {
        Collections.addAll(this.flags, flags);
        return this;
    }

    public String toString() {
        return "OptionDescription{" + this.desc + ", values=" + String.valueOf(this.values) + "}";
    }
}

