/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.impl;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.impl.AnnotatedCodeInfo;
import jadx.api.impl.SimpleCodeWriter;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AnnotatedCodeWriter
extends SimpleCodeWriter
implements ICodeWriter {
    private int line = 1;
    private int offset;
    private Map<Integer, ICodeAnnotation> annotations = Collections.emptyMap();
    private Map<Integer, Integer> lineMap = Collections.emptyMap();

    public AnnotatedCodeWriter(JadxArgs args) {
        super(args);
    }

    @Override
    public boolean isMetadataSupported() {
        return true;
    }

    @Override
    public AnnotatedCodeWriter addMultiLine(String str) {
        if (str.contains(this.newLineStr)) {
            this.buf.append(str.replace(this.newLineStr, this.newLineStr + this.indentStr));
            this.line += StringUtils.countMatches(str, this.newLineStr);
            this.offset = 0;
        } else {
            this.buf.append(str);
        }
        return this;
    }

    @Override
    public AnnotatedCodeWriter add(String str) {
        this.buf.append(str);
        this.offset += str.length();
        return this;
    }

    @Override
    public AnnotatedCodeWriter add(char c15) {
        this.buf.append(c15);
        ++this.offset;
        return this;
    }

    @Override
    public ICodeWriter add(ICodeWriter cw4) {
        if (!cw4.isMetadataSupported()) {
            this.buf.append(cw4.getCodeStr());
            return this;
        }
        AnnotatedCodeWriter code = (AnnotatedCodeWriter)cw4;
        --this.line;
        int startPos = this.getLength();
        for (Map.Entry<Integer, ICodeAnnotation> entry : code.annotations.entrySet()) {
            int pos = entry.getKey();
            int newPos = startPos + pos;
            this.attachAnnotation(entry.getValue(), newPos);
        }
        for (Map.Entry<Integer, Object> entry : code.lineMap.entrySet()) {
            this.attachSourceLine(this.line + entry.getKey(), (Integer)entry.getValue());
        }
        this.line += code.line;
        this.offset = code.offset;
        this.buf.append((CharSequence)code.buf);
        return this;
    }

    @Override
    protected void addLine() {
        this.buf.append(this.newLineStr);
        ++this.line;
        this.offset = 0;
    }

    @Override
    protected AnnotatedCodeWriter addLineIndent() {
        this.buf.append(this.indentStr);
        this.offset += this.indentStr.length();
        return this;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getLineStartPos() {
        return this.getLength() - this.offset;
    }

    @Override
    public void attachDefinition(ICodeNodeRef obj) {
        if (obj == null) {
            return;
        }
        this.attachAnnotation(new NodeDeclareRef(obj));
    }

    @Override
    public void attachAnnotation(ICodeAnnotation obj) {
        if (obj == null) {
            return;
        }
        this.attachAnnotation(obj, this.getLength());
    }

    @Override
    public void attachLineAnnotation(ICodeAnnotation obj) {
        if (obj == null) {
            return;
        }
        this.attachAnnotation(obj, this.getLineStartPos());
    }

    private void attachAnnotation(ICodeAnnotation obj, int pos) {
        if (this.annotations.isEmpty()) {
            this.annotations = new HashMap<Integer, ICodeAnnotation>();
        }
        this.annotations.put(pos, obj);
    }

    @Override
    public void attachSourceLine(int sourceLine) {
        if (sourceLine == 0) {
            return;
        }
        this.attachSourceLine(this.line, sourceLine);
    }

    private void attachSourceLine(int decompiledLine, int sourceLine) {
        if (this.lineMap.isEmpty()) {
            this.lineMap = new TreeMap<Integer, Integer>();
        }
        this.lineMap.put(decompiledLine, sourceLine);
    }

    @Override
    public ICodeInfo finish() {
        String code = this.buf.toString();
        this.buf = null;
        return new AnnotatedCodeInfo(code, this.lineMap, this.annotations);
    }

    @Override
    public Map<Integer, ICodeAnnotation> getRawAnnotations() {
        return this.annotations;
    }
}

