/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SerializedProcessor<T>
extends FlowableProcessor<T> {
    final FlowableProcessor<T> actual;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    SerializedProcessor(FlowableProcessor<T> actual) {
        this.actual = actual;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.actual.subscribe(s15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Subscription s15) {
        boolean cancel;
        if (!this.done) {
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                        if (q15 == null) {
                            this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                        }
                        q15.add(NotificationLite.subscription(s15));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            s15.cancel();
        } else {
            this.actual.onSubscribe(s15);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t15) {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.next(t15));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t15);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t15) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                reportError = true;
            } else {
                this.done = true;
                if (this.emitting) {
                    AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                    if (q15 == null) {
                        this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                    }
                    q15.setFirst(NotificationLite.error(t15));
                    return;
                }
                reportError = false;
                this.emitting = true;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.actual.onError(t15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.complete());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<Object> q15;
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                q15 = this.queue;
                if (q15 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q15.accept(this.actual);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.actual.hasSubscribers();
    }

    @Override
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    public boolean hasComplete() {
        return this.actual.hasComplete();
    }
}

