/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ScheduledRunnable
extends AtomicReferenceArray<Object>
implements Runnable,
Callable<Object>,
Disposable {
    private static final long serialVersionUID = -6120223772001106981L;
    final Runnable actual;
    final boolean interruptOnCancel;
    static final Object PARENT_DISPOSED = new Object();
    static final Object SYNC_DISPOSED = new Object();
    static final Object ASYNC_DISPOSED = new Object();
    static final Object DONE = new Object();
    static final int PARENT_INDEX = 0;
    static final int FUTURE_INDEX = 1;
    static final int THREAD_INDEX = 2;

    public ScheduledRunnable(Runnable actual, DisposableContainer parent) {
        this(actual, parent, true);
    }

    public ScheduledRunnable(Runnable actual, DisposableContainer parent, boolean interruptOnCancel) {
        super(3);
        this.actual = actual;
        this.interruptOnCancel = interruptOnCancel;
        this.lazySet(0, parent);
    }

    @Override
    public Object call() {
        this.run();
        return null;
    }

    @Override
    public void run() {
        this.lazySet(2, Thread.currentThread());
        try {
            try {
                this.actual.run();
            }
            catch (Throwable e15) {
                RxJavaPlugins.onError(e15);
                throw e15;
            }
        }
        finally {
            Object o15 = this.get(0);
            if (o15 != PARENT_DISPOSED && this.compareAndSet(0, o15, DONE) && o15 != null) {
                ((DisposableContainer)o15).delete(this);
            }
            while ((o15 = this.get(1)) != SYNC_DISPOSED && o15 != ASYNC_DISPOSED && !this.compareAndSet(1, o15, DONE)) {
            }
            this.lazySet(2, null);
        }
    }

    public void setFuture(Future<?> f15) {
        Object o15;
        do {
            if ((o15 = this.get(1)) == DONE) {
                return;
            }
            if (o15 == SYNC_DISPOSED) {
                f15.cancel(false);
                return;
            }
            if (o15 != ASYNC_DISPOSED) continue;
            f15.cancel(this.interruptOnCancel);
            return;
        } while (!this.compareAndSet(1, o15, f15));
    }

    @Override
    public void dispose() {
        Object o15;
        while ((o15 = this.get(1)) != DONE && o15 != SYNC_DISPOSED && o15 != ASYNC_DISPOSED) {
            boolean async = this.get(2) != Thread.currentThread();
            if (!this.compareAndSet(1, o15, async ? ASYNC_DISPOSED : SYNC_DISPOSED)) continue;
            if (o15 == null) break;
            ((Future)o15).cancel(async && this.interruptOnCancel);
            break;
        }
        do {
            if ((o15 = this.get(0)) != DONE && o15 != PARENT_DISPOSED && o15 != null) continue;
            return;
        } while (!this.compareAndSet(0, o15, PARENT_DISPOSED));
        ((DisposableContainer)o15).delete(this);
    }

    @Override
    public boolean isDisposed() {
        Object o15 = this.get(0);
        return o15 == PARENT_DISPOSED || o15 == DONE;
    }

    @Override
    public String toString() {
        Object o15 = this.get(1);
        String state = o15 == DONE ? "Finished" : (o15 == SYNC_DISPOSED ? "Disposed(Sync)" : (o15 == ASYNC_DISPOSED ? "Disposed(Async)" : ((o15 = this.get(2)) == null ? "Waiting" : "Running on " + o15)));
        return this.getClass().getSimpleName() + "[" + state + "]";
    }
}

