/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SingleFlatMapPublisher<T, R>
extends Flowable<R> {
    final SingleSource<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;

    public SingleFlatMapPublisher(SingleSource<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> downstream) {
        this.source.subscribe(new SingleFlatMapPublisherObserver<T, R>(downstream, this.mapper));
    }

    static final class SingleFlatMapPublisherObserver<S, T>
    extends AtomicLong
    implements SingleObserver<S>,
    FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 7759721921468635667L;
        final Subscriber<? super T> downstream;
        final Function<? super S, ? extends Publisher<? extends T>> mapper;
        final AtomicReference<Subscription> parent;
        Disposable disposable;

        SingleFlatMapPublisherObserver(Subscriber<? super T> actual, Function<? super S, ? extends Publisher<? extends T>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
            this.parent = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.disposable = d15;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onSuccess(S value) {
            Publisher<T> f15;
            try {
                f15 = Objects.requireNonNull(this.mapper.apply(value), "the mapper returned a null Publisher");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                return;
            }
            if (this.parent.get() != SubscriptionHelper.CANCELLED) {
                f15.subscribe(this);
            }
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.deferredSetOnce(this.parent, this, s15);
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e15) {
            this.downstream.onError(e15);
        }

        @Override
        public void request(long n15) {
            SubscriptionHelper.deferredRequest(this.parent, this, n15);
        }

        @Override
        public void cancel() {
            this.disposable.dispose();
            SubscriptionHelper.cancel(this.parent);
        }
    }
}

