/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableCreate<T>
extends Observable<T> {
    final ObservableOnSubscribe<T> source;

    public ObservableCreate(ObservableOnSubscribe<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        CreateEmitter<T> parent = new CreateEmitter<T>(observer);
        observer.onSubscribe(parent);
        try {
            this.source.subscribe(parent);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            parent.onError(ex4);
        }
    }

    static final class SerializedEmitter<T>
    extends AtomicInteger
    implements ObservableEmitter<T> {
        private static final long serialVersionUID = 4883307006032401862L;
        final ObservableEmitter<T> emitter;
        final AtomicThrowable errors;
        final SpscLinkedArrayQueue<T> queue;
        volatile boolean done;

        SerializedEmitter(ObservableEmitter<T> emitter) {
            this.emitter = emitter;
            this.errors = new AtomicThrowable();
            this.queue = new SpscLinkedArrayQueue(16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            if (this.done || this.emitter.isDisposed()) {
                return;
            }
            if (t15 == null) {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.emitter.onNext(t15);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SpscLinkedArrayQueue<T> q15;
                SpscLinkedArrayQueue<T> spscLinkedArrayQueue = q15 = this.queue;
                synchronized (spscLinkedArrayQueue) {
                    q15.offer(t15);
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.tryOnError(t15)) {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public boolean tryOnError(Throwable t15) {
            if (this.done || this.emitter.isDisposed()) {
                return false;
            }
            if (t15 == null) {
                t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
            }
            if (this.errors.tryAddThrowable(t15)) {
                this.done = true;
                this.drain();
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (this.done || this.emitter.isDisposed()) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            ObservableEmitter<T> e15 = this.emitter;
            SpscLinkedArrayQueue<T> q15 = this.queue;
            AtomicThrowable errors = this.errors;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e15.isDisposed()) {
                    q15.clear();
                    return;
                }
                if (errors.get() != null) {
                    q15.clear();
                    errors.tryTerminateConsumer(e15);
                    return;
                }
                boolean d15 = this.done;
                T v15 = q15.poll();
                boolean bl4 = empty = v15 == null;
                if (d15 && empty) {
                    e15.onComplete();
                    return;
                }
                if (!empty) {
                    e15.onNext(v15);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void setDisposable(Disposable d15) {
            this.emitter.setDisposable(d15);
        }

        @Override
        public void setCancellable(Cancellable c15) {
            this.emitter.setCancellable(c15);
        }

        @Override
        public boolean isDisposed() {
            return this.emitter.isDisposed();
        }

        @Override
        public ObservableEmitter<T> serialize() {
            return this;
        }

        @Override
        public String toString() {
            return this.emitter.toString();
        }
    }

    static final class CreateEmitter<T>
    extends AtomicReference<Disposable>
    implements ObservableEmitter<T>,
    Disposable {
        private static final long serialVersionUID = -3434801548987643227L;
        final Observer<? super T> observer;

        CreateEmitter(Observer<? super T> observer) {
            this.observer = observer;
        }

        @Override
        public void onNext(T t15) {
            if (t15 == null) {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            if (!this.isDisposed()) {
                this.observer.onNext(t15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.tryOnError(t15)) {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public boolean tryOnError(Throwable t15) {
            if (t15 == null) {
                t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
            }
            if (!this.isDisposed()) {
                try {
                    this.observer.onError(t15);
                }
                finally {
                    this.dispose();
                }
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (!this.isDisposed()) {
                try {
                    this.observer.onComplete();
                }
                finally {
                    this.dispose();
                }
            }
        }

        @Override
        public void setDisposable(Disposable d15) {
            DisposableHelper.set(this, d15);
        }

        @Override
        public void setCancellable(Cancellable c15) {
            this.setDisposable(new CancellableDisposable(c15));
        }

        @Override
        public ObservableEmitter<T> serialize() {
            return new SerializedEmitter(this);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }
}

