/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeToObservable;
import io.reactivex.rxjava3.internal.operators.single.SingleToObservable;
import java.util.Objects;

final class ScalarXMapZHelper {
    private ScalarXMapZHelper() {
        throw new IllegalStateException("No instances!");
    }

    static <T> boolean tryAsCompletable(Object source, Function<? super T, ? extends CompletableSource> mapper, CompletableObserver observer) {
        if (source instanceof Supplier) {
            Supplier supplier = (Supplier)source;
            CompletableSource cs4 = null;
            try {
                Object item = supplier.get();
                if (item != null) {
                    cs4 = Objects.requireNonNull(mapper.apply(item), "The mapper returned a null CompletableSource");
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptyDisposable.error(ex4, observer);
                return true;
            }
            if (cs4 == null) {
                EmptyDisposable.complete(observer);
            } else {
                cs4.subscribe(observer);
            }
            return true;
        }
        return false;
    }

    static <T, R> boolean tryAsMaybe(Object source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, Observer<? super R> observer) {
        if (source instanceof Supplier) {
            Supplier supplier = (Supplier)source;
            MaybeSource<R> cs4 = null;
            try {
                Object item = supplier.get();
                if (item != null) {
                    cs4 = Objects.requireNonNull(mapper.apply(item), "The mapper returned a null MaybeSource");
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptyDisposable.error(ex4, observer);
                return true;
            }
            if (cs4 == null) {
                EmptyDisposable.complete(observer);
            } else {
                cs4.subscribe(MaybeToObservable.create(observer));
            }
            return true;
        }
        return false;
    }

    static <T, R> boolean tryAsSingle(Object source, Function<? super T, ? extends SingleSource<? extends R>> mapper, Observer<? super R> observer) {
        if (source instanceof Supplier) {
            Supplier supplier = (Supplier)source;
            SingleSource<R> cs4 = null;
            try {
                Object item = supplier.get();
                if (item != null) {
                    cs4 = Objects.requireNonNull(mapper.apply(item), "The mapper returned a null SingleSource");
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptyDisposable.error(ex4, observer);
                return true;
            }
            if (cs4 == null) {
                EmptyDisposable.complete(observer);
            } else {
                cs4.subscribe(SingleToObservable.create(observer));
            }
            return true;
        }
        return false;
    }
}

