/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDistinctUntilChanged<T, K>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;

    public FlowableDistinctUntilChanged(Flowable<T> source, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(source);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            ConditionalSubscriber cs4 = (ConditionalSubscriber)s15;
            this.source.subscribe(new DistinctUntilChangedConditionalSubscriber<T, K>(cs4, this.keySelector, this.comparer));
        } else {
            this.source.subscribe(new DistinctUntilChangedSubscriber<T, K>(s15, this.keySelector, this.comparer));
        }
    }

    static final class DistinctUntilChangedConditionalSubscriber<T, K>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedConditionalSubscriber(ConditionalSubscriber<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.downstream.tryOnNext(t15);
            }
            try {
                K key = this.keySelector.apply(t15);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return false;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return true;
            }
            this.downstream.onNext(t15);
            return true;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15;
            while ((v15 = this.qs.poll()) != null) {
                K key = this.keySelector.apply(v15);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return v15;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return v15;
                }
                this.last = key;
                if (this.sourceMode == 1) continue;
                this.upstream.request(1L);
            }
            return null;
        }
    }

    static final class DistinctUntilChangedSubscriber<T, K>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedSubscriber(Subscriber<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(t15);
                return true;
            }
            try {
                K key = this.keySelector.apply(t15);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return false;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return true;
            }
            this.downstream.onNext(t15);
            return true;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15;
            while ((v15 = this.qs.poll()) != null) {
                K key = this.keySelector.apply(v15);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return v15;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return v15;
                }
                this.last = key;
                if (this.sourceMode == 1) continue;
                this.upstream.request(1L);
            }
            return null;
        }
    }
}

