/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMap;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCombineLatest<T, R>
extends Flowable<R> {
    @Nullable
    final Publisher<? extends T>[] array;
    @Nullable
    final Iterable<? extends Publisher<? extends T>> iterable;
    final Function<? super Object[], ? extends R> combiner;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableCombineLatest(@NonNull Publisher<? extends T>[] array, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = array;
        this.iterable = null;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    public FlowableCombineLatest(@NonNull Iterable<? extends Publisher<? extends T>> iterable, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = null;
        this.iterable = iterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s15) {
        int count;
        Publisher<? extends T>[] sources = this.array;
        if (sources == null) {
            count = 0;
            sources = new Publisher[8];
            try {
                for (Publisher<? extends T> publisher : this.iterable) {
                    if (count == sources.length) {
                        Publisher[] b15 = new Publisher[count + (count >> 2)];
                        System.arraycopy(sources, 0, b15, 0, count);
                        sources = b15;
                    }
                    sources[count++] = Objects.requireNonNull(publisher, "The Iterator returned a null Publisher");
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptySubscription.error(ex4, s15);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s15);
            return;
        }
        if (count == 1) {
            sources[0].subscribe(new FlowableMap.MapSubscriber(s15, new SingletonArrayFunc()));
            return;
        }
        CombineLatestCoordinator<? extends T, R> coordinator = new CombineLatestCoordinator<T, R>(s15, this.combiner, count, this.bufferSize, this.delayErrors);
        s15.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t15) throws Throwable {
            return FlowableCombineLatest.this.combiner.apply((Object[])new Object[]{t15});
        }
    }

    static final class CombineLatestInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -8730235182291002949L;
        final CombineLatestCoordinator<T, ?> parent;
        final int index;
        final int prefetch;
        final int limit;
        int produced;

        CombineLatestInnerSubscriber(CombineLatestCoordinator<T, ?> parent, int index, int prefetch) {
            this.parent = parent;
            this.index = index;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, this.prefetch);
        }

        @Override
        public void onNext(T t15) {
            this.parent.innerValue(this.index, t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(this.index, t15);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void requestOne() {
            int p15 = this.produced + 1;
            if (p15 == this.limit) {
                this.produced = 0;
                ((Subscription)this.get()).request(p15);
            } else {
                this.produced = p15;
            }
        }
    }

    static final class CombineLatestCoordinator<T, R>
    extends BasicIntQueueSubscription<R> {
        private static final long serialVersionUID = -5082275438355852221L;
        final Subscriber<? super R> downstream;
        final Function<? super Object[], ? extends R> combiner;
        final CombineLatestInnerSubscriber<T>[] subscribers;
        final SpscLinkedArrayQueue<Object> queue;
        final Object[] latest;
        final boolean delayErrors;
        boolean outputFused;
        int nonEmptySources;
        int completedSources;
        volatile boolean cancelled;
        final AtomicLong requested;
        volatile boolean done;
        final AtomicThrowable error;

        CombineLatestCoordinator(Subscriber<? super R> actual, Function<? super Object[], ? extends R> combiner, int n15, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.combiner = combiner;
            CombineLatestInnerSubscriber[] a15 = new CombineLatestInnerSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                a15[i15] = new CombineLatestInnerSubscriber(this, i15, bufferSize);
            }
            this.subscribers = a15;
            this.latest = new Object[n15];
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
            this.delayErrors = delayErrors;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.cancelAll();
            this.drain();
        }

        void subscribe(Publisher<? extends T>[] sources, int n15) {
            CombineLatestInnerSubscriber<T>[] a15 = this.subscribers;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (this.done || this.cancelled) {
                    return;
                }
                sources[i15].subscribe(a15[i15]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerValue(int index, T value) {
            boolean replenishInsteadOfDrain;
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os4 = this.latest;
                int localNonEmptySources = this.nonEmptySources;
                if (os4[index] == null) {
                    this.nonEmptySources = ++localNonEmptySources;
                }
                os4[index] = value;
                if (os4.length == localNonEmptySources) {
                    this.queue.offer(this.subscribers[index], os4.clone());
                    replenishInsteadOfDrain = false;
                } else {
                    replenishInsteadOfDrain = true;
                }
            }
            if (replenishInsteadOfDrain) {
                this.subscribers[index].requestOne();
            } else {
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void innerComplete(int index) {
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os4 = this.latest;
                if (os4[index] != null) {
                    int localCompletedSources = this.completedSources + 1;
                    if (localCompletedSources != os4.length) {
                        this.completedSources = localCompletedSources;
                        return;
                    }
                    this.done = true;
                } else {
                    this.done = true;
                }
            }
            this.drain();
        }

        void innerError(int index, Throwable e15) {
            if (ExceptionHelper.addThrowable(this.error, e15)) {
                if (!this.delayErrors) {
                    this.cancelAll();
                    this.done = true;
                    this.drain();
                } else {
                    this.innerComplete(index);
                }
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        void drainOutput() {
            Subscriber<R> a15 = this.downstream;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            int missed = 1;
            do {
                if (this.cancelled) {
                    q15.clear();
                    return;
                }
                Throwable ex4 = (Throwable)this.error.get();
                if (ex4 != null) {
                    q15.clear();
                    a15.onError(ex4);
                    return;
                }
                boolean d15 = this.done;
                boolean empty = q15.isEmpty();
                if (!empty) {
                    a15.onNext(null);
                }
                if (!d15 || !empty) continue;
                a15.onComplete();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drainAsync() {
            Subscriber<R> a15 = this.downstream;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            int missed = 1;
            do {
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    R w15;
                    boolean empty;
                    boolean d15 = this.done;
                    Object v15 = q15.poll();
                    boolean bl4 = empty = v15 == null;
                    if (this.checkTerminated(d15, empty, a15, q15)) {
                        return;
                    }
                    if (empty) break;
                    Object[] va5 = (Object[])q15.poll();
                    try {
                        w15 = Objects.requireNonNull(this.combiner.apply((Object[])va5), "The combiner returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancelAll();
                        ExceptionHelper.addThrowable(this.error, ex4);
                        ex4 = ExceptionHelper.terminate(this.error);
                        a15.onError(ex4);
                        return;
                    }
                    a15.onNext(w15);
                    ((CombineLatestInnerSubscriber)v15).requestOne();
                }
                if (e15 == r15 && this.checkTerminated(this.done, q15.isEmpty(), a15, q15)) {
                    return;
                }
                if (e15 == 0L || r15 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainOutput();
            } else {
                this.drainAsync();
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Subscriber<?> a15, SpscLinkedArrayQueue<?> q15) {
            if (this.cancelled) {
                this.cancelAll();
                q15.clear();
                this.error.tryTerminateAndReport();
                return true;
            }
            if (d15) {
                if (this.delayErrors) {
                    if (empty) {
                        this.cancelAll();
                        this.error.tryTerminateConsumer(a15);
                        return true;
                    }
                } else {
                    Throwable e15 = ExceptionHelper.terminate(this.error);
                    if (e15 != null && e15 != ExceptionHelper.TERMINATED) {
                        this.cancelAll();
                        q15.clear();
                        a15.onError(e15);
                        return true;
                    }
                    if (empty) {
                        this.cancelAll();
                        a15.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        void cancelAll() {
            for (CombineLatestInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            int m15 = requestedMode & 2;
            this.outputFused = m15 != 0;
            return m15;
        }

        @Override
        @Nullable
        public R poll() throws Throwable {
            Object e15 = this.queue.poll();
            if (e15 == null) {
                return null;
            }
            Object[] a15 = (Object[])this.queue.poll();
            R r15 = Objects.requireNonNull(this.combiner.apply((Object[])a15), "The combiner returned a null value");
            ((CombineLatestInnerSubscriber)e15).requestOne();
            return r15;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

