/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RaungAccessFlags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int SUPER = 32;
    public static final int VOLATILE = 64;
    public static final int BRIDGE = 64;
    public static final int TRANSIENT = 128;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MODULE = 32768;
    public static final int MANDATED = 32768;
    public static final int CONSTRUCTOR = 65536;
    public static final int DECLARED_SYNCHRONIZED = 131072;
    private static final List<AccFlagsInfo> FLAGS_LIST = new ArrayList<AccFlagsInfo>();
    private static final Map<String, AccFlagsInfo> FLAGS_MAP = new HashMap<String, AccFlagsInfo>();

    private static void add(String name, int accessFlag, Scope scope) {
        RaungAccessFlags.add(new AccFlagsInfo(name, accessFlag, scope.getFlag()));
    }

    private static void add(String name, int accessFlag, Scope scope, Scope secondScope) {
        RaungAccessFlags.add(new AccFlagsInfo(name, accessFlag, scope.getFlag() | secondScope.getFlag()));
    }

    private static void add(AccFlagsInfo info) {
        FLAGS_LIST.add(info);
        FLAGS_MAP.put(info.name, info);
    }

    public static int parseToken(String token, Scope scope) {
        AccFlagsInfo info = FLAGS_MAP.get(token);
        if (info == null || (info.scopeFlags & scope.getFlag()) == 0) {
            return -1;
        }
        return info.accessFlag;
    }

    public static String format(int flags, Scope scope) {
        if (flags == 0) {
            return "";
        }
        int remFlags = flags;
        int scopeFlag = scope.getFlag();
        StringBuilder sb5 = new StringBuilder();
        for (AccFlagsInfo flag : FLAGS_LIST) {
            if (!RaungAccessFlags.hasFlag(remFlags, flag.accessFlag) || !RaungAccessFlags.hasFlag(flag.scopeFlags, scopeFlag)) continue;
            remFlags &= ~flag.accessFlag;
            sb5.append(flag.name).append(' ');
        }
        if (remFlags != 0) {
            sb5.append("0x").append(Integer.toHexString(remFlags)).append(' ');
        }
        return sb5.toString();
    }

    private static boolean hasFlag(int flags, int flagValue) {
        return (flags & flagValue) != 0;
    }

    static {
        RaungAccessFlags.add("public", 1, Scope.ANY);
        RaungAccessFlags.add("private", 2, Scope.ANY);
        RaungAccessFlags.add("protected", 4, Scope.ANY);
        RaungAccessFlags.add("static", 8, Scope.ANY);
        RaungAccessFlags.add("final", 16, Scope.ANY);
        RaungAccessFlags.add("synthetic", 4096, Scope.ANY);
        RaungAccessFlags.add("super", 32, Scope.CLASS);
        RaungAccessFlags.add("interface", 512, Scope.CLASS);
        RaungAccessFlags.add("annotation", 8192, Scope.CLASS);
        RaungAccessFlags.add("module", 32768, Scope.CLASS);
        RaungAccessFlags.add("enum", 16384, Scope.CLASS, Scope.FIELD);
        RaungAccessFlags.add("abstract", 1024, Scope.CLASS, Scope.METHOD);
        RaungAccessFlags.add("constructor", 65536, Scope.METHOD);
        RaungAccessFlags.add("synchronized", 32, Scope.METHOD);
        RaungAccessFlags.add("varargs", 128, Scope.METHOD);
        RaungAccessFlags.add("bridge", 64, Scope.METHOD);
        RaungAccessFlags.add("native", 256, Scope.METHOD);
        RaungAccessFlags.add("strict", 2048, Scope.METHOD);
        RaungAccessFlags.add("transient", 128, Scope.FIELD);
        RaungAccessFlags.add("volatile", 64, Scope.FIELD);
        RaungAccessFlags.add("mandated", 32768, Scope.PARAM);
    }

    private static final class AccFlagsInfo {
        String name;
        int accessFlag;
        int scopeFlags;

        public AccFlagsInfo(String name, int accessFlag, int scopeFlags) {
            this.name = name;
            this.accessFlag = accessFlag;
            this.scopeFlags = scopeFlags;
        }
    }

    public static enum Scope {
        CLASS(1),
        FIELD(2),
        METHOD(4),
        PARAM(8),
        ANY(15);

        private final int flag;

        private Scope(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

