/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.Seekable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public abstract class SeekableInputStream
extends InputStream
implements Seekable {
    long position;
    long flushedPosition;
    boolean closed;
    protected Stack<Long> markedPositions = new Stack();

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray != null ? byArray.length : 1);
    }

    @Override
    public final long skip(long l15) throws IOException {
        long l16 = this.position;
        long l17 = l16 + l15;
        if (l17 < this.flushedPosition) {
            throw new IOException("position < flushedPosition");
        }
        int n15 = this.available();
        if (n15 > 0) {
            this.seek(Math.min(l17, l16 + (long)n15));
        } else {
            for (int i15 = (int)Math.max(Math.min(l15, 512L), -512L); i15 > 0 && this.read() >= 0; --i15) {
            }
        }
        return this.position - l16;
    }

    @Override
    public final void mark(int n15) {
        this.mark();
        try {
            this.flushBefore(Math.max(this.position - (long)n15, this.flushedPosition));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final void seek(long l15) throws IOException {
        this.checkOpen();
        if (l15 < this.flushedPosition) {
            throw new IndexOutOfBoundsException("position < flushedPosition");
        }
        this.seekImpl(l15);
        this.position = l15;
    }

    protected abstract void seekImpl(long var1) throws IOException;

    @Override
    public final void mark() {
        this.markedPositions.push(this.position);
    }

    @Override
    public final void reset() throws IOException {
        this.checkOpen();
        if (!this.markedPositions.isEmpty()) {
            long l15 = this.markedPositions.pop();
            if (l15 < this.flushedPosition) {
                throw new IOException("Previous marked position has been discarded");
            }
            this.seek(l15);
        } else {
            this.seek(0L);
        }
    }

    @Override
    public final void flushBefore(long l15) throws IOException {
        if (l15 < this.flushedPosition) {
            throw new IndexOutOfBoundsException("position < flushedPosition");
        }
        if (l15 > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("position > stream position");
        }
        this.checkOpen();
        this.flushBeforeImpl(l15);
        this.flushedPosition = l15;
    }

    protected abstract void flushBeforeImpl(long var1) throws IOException;

    @Override
    public final void flush() throws IOException {
        this.flushBefore(this.flushedPosition);
    }

    @Override
    public final long getFlushedPosition() throws IOException {
        this.checkOpen();
        return this.flushedPosition;
    }

    @Override
    public final long getStreamPosition() throws IOException {
        this.checkOpen();
        return this.position;
    }

    protected final void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
    }

    @Override
    public final void close() throws IOException {
        this.checkOpen();
        this.closed = true;
        this.closeImpl();
    }

    protected abstract void closeImpl() throws IOException;

    protected void finalize() throws Throwable {
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

