/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.lang.Validate;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public final class RasterUtils {
    private RasterUtils() {
    }

    public static Raster asByteRaster(Raster raster) {
        return RasterUtils.asByteRaster0(raster);
    }

    public static WritableRaster asByteRaster(WritableRaster writableRaster) {
        return (WritableRaster)RasterUtils.asByteRaster0(writableRaster);
    }

    private static Raster asByteRaster0(Raster raster) {
        switch (raster.getTransferType()) {
            case 0: {
                return raster;
            }
            case 3: {
                SampleModel sampleModel = raster.getSampleModel();
                if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
                    throw new IllegalArgumentException(String.format("Requires SinglePixelPackedSampleModel, %s not supported", sampleModel.getClass().getSimpleName()));
                }
                final DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                int n15 = raster.getWidth();
                int n16 = raster.getHeight();
                int n17 = dataBufferInt.getSize();
                return new WritableRaster(new PixelInterleavedSampleModel(0, n15, n16, 4, n15 * 4, RasterUtils.createBandOffsets((SinglePixelPackedSampleModel)sampleModel)), new DataBuffer(0, n17 * 4){
                    final int[] MASKS;
                    {
                        super(n15, n16);
                        this.MASKS = new int[]{-256, -65281, -16711681, 0xFFFFFF};
                    }

                    @Override
                    public int getElem(int n15, int n16) {
                        int n17 = n16 / 4;
                        int n18 = n16 % 4 * 8;
                        return dataBufferInt.getElem(n17) >>> n18 & 0xFF;
                    }

                    @Override
                    public void setElem(int n15, int n16, int n17) {
                        int n18 = n16 / 4;
                        int n19 = n16 % 4;
                        int n25 = n19 * 8;
                        int n26 = dataBufferInt.getElem(n18) & this.MASKS[n19] | (n17 & 0xFF) << n25;
                        dataBufferInt.setElem(n18, n26);
                    }
                }, new Point()){};
            }
        }
        throw new IllegalArgumentException(String.format("Raster type %d not supported", raster.getTransferType()));
    }

    private static int[] createBandOffsets(SinglePixelPackedSampleModel singlePixelPackedSampleModel) {
        Validate.notNull(singlePixelPackedSampleModel, "sampleModel");
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        int[] nArray2 = new int[nArray.length];
        for (int i15 = 0; i15 < nArray.length; ++i15) {
            int n15 = nArray[i15];
            int n16 = 0;
            if (n15 != 0) {
                while ((n15 & 0xFF) == 0) {
                    n15 >>>= 8;
                    ++n16;
                }
            }
            nArray2[i15] = n16;
        }
        return nArray2;
    }
}

