/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.util.IIOInputStreamAdapter;
import com.twelvemonkeys.imageio.util.IIOOutputStreamAdapter;
import com.twelvemonkeys.lang.Validate;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeSet;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class IIOUtil {
    private IIOUtil() {
    }

    public static InputStream createStreamAdapter(ImageInputStream imageInputStream) {
        return new BufferedInputStream(new IIOInputStreamAdapter(imageInputStream));
    }

    public static InputStream createStreamAdapter(ImageInputStream imageInputStream, long l15) {
        return new BufferedInputStream(new IIOInputStreamAdapter(imageInputStream, l15));
    }

    public static OutputStream createStreamAdapter(ImageOutputStream imageOutputStream) {
        return new BufferedOutputStream(new IIOOutputStreamAdapter(imageOutputStream));
    }

    public static Image fakeSubsampling(Image image, IIOParam iIOParam) {
        if (image == null) {
            return null;
        }
        if (iIOParam != null) {
            int n15 = iIOParam.getSourceXSubsampling();
            int n16 = iIOParam.getSourceYSubsampling();
            if (n15 > 1 || n16 > 1) {
                int n17 = (ImageUtil.getWidth(image) + n15 - 1) / n15;
                int n18 = (ImageUtil.getHeight(image) + n16 - 1) / n16;
                return image.getScaledInstance(n17, n18, 2);
            }
        }
        return image;
    }

    public static Rectangle getSourceRegion(IIOParam iIOParam, int n15, int n16) {
        Rectangle rectangle = new Rectangle(n15, n16);
        if (iIOParam != null) {
            Rectangle rectangle2 = iIOParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n17 = iIOParam.getSubsamplingXOffset();
            int n18 = iIOParam.getSubsamplingYOffset();
            rectangle.x += n17;
            rectangle.y += n18;
            rectangle.width -= n17;
            rectangle.height -= n18;
        }
        return rectangle;
    }

    public static BufferedImage fakeAOI(BufferedImage bufferedImage, Rectangle rectangle) {
        if (bufferedImage == null) {
            return null;
        }
        if (rectangle != null && (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != bufferedImage.getWidth() || rectangle.height != bufferedImage.getHeight())) {
            return bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return bufferedImage;
    }

    public static <T> void deregisterProvider(ServiceRegistry serviceRegistry, IIOServiceProvider iIOServiceProvider, Class<T> clazz) {
        serviceRegistry.deregisterServiceProvider(clazz.cast(iIOServiceProvider), clazz);
    }

    public static <T> T lookupProviderByName(ServiceRegistry serviceRegistry, String string, Class<T> clazz) {
        Iterator<T> iterator2 = serviceRegistry.getServiceProviders(clazz, true);
        while (iterator2.hasNext()) {
            T t15 = iterator2.next();
            if (!t15.getClass().getName().equals(string)) continue;
            return t15;
        }
        return null;
    }

    public static String[] getNormalizedReaderFormatNames() {
        return IIOUtil.normalizeNames(ImageIO.getReaderFormatNames());
    }

    public static String[] getNormalizedWriterFormatNames() {
        return IIOUtil.normalizeNames(ImageIO.getWriterFormatNames());
    }

    private static String[] normalizeNames(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : stringArray) {
            treeSet.add(string.toUpperCase());
        }
        return treeSet.toArray(new String[0]);
    }

    public static void subsampleRow(byte[] byArray, int n15, int n16, byte[] byArray2, int n17, int n18, int n19, int n25) {
        if (n25 == 1) {
            if (byArray != byArray2) {
                System.arraycopy(byArray, n15, byArray2, n17, n16);
            }
            return;
        }
        Validate.isTrue(n25 > 1, "samplePeriod must be > 1");
        Validate.isTrue(n19 > 0 && n19 <= 8 && (n19 == 1 || n19 % 2 == 0), "bitsPerSample must be > 0 and <= 8 and a power of 2");
        Validate.isTrue(n18 > 0, "samplesPerPixel must be > 0");
        Validate.isTrue(n18 * n19 <= 8 || n18 * n19 % 8 == 0, "samplesPerPixel * bitsPerSample must be < 8 or a multiple of 8 ");
        if (n19 * n18 % 8 == 0) {
            int n26 = n19 * n18 / 8;
            for (int i15 = 0; i15 < n16 * n26; i15 += n25 * n26) {
                System.arraycopy(byArray, n15 + i15, byArray2, n17 + i15 / n25, n26);
            }
        } else {
            int n27 = n19 * n18;
            int n28 = (1 << n27) - 1;
            for (int i16 = 0; i16 < n16; i16 += n25) {
                int n29 = (n17 + i16 / n25) * n27 / 8;
                int n35 = (n15 + i16) * n27 / 8;
                int n36 = 8 - n27 - i16 * n27 % 8;
                int n37 = n28 << n36;
                int n38 = 8 - n27 - i16 * n27 / n25 % 8;
                int n39 = ~(n28 << n38);
                int n45 = (byArray[n35] & n37) >> n36;
                byArray2[n29] = (byte)(byArray2[n29] & n39 | n45 << n38);
            }
        }
    }

    public static void subsampleRow(short[] sArray, int n15, int n16, short[] sArray2, int n17, int n18, int n19, int n25) {
        if (n25 == 1) {
            if (sArray != sArray2) {
                System.arraycopy(sArray, n15, sArray2, n17, n16);
            }
            return;
        }
        Validate.isTrue(n25 > 1, "samplePeriod must be > 1");
        Validate.isTrue(n19 > 0 && n19 <= 16 && (n19 == 1 || n19 % 2 == 0), "bitsPerSample must be > 0 and <= 16 and a power of 2");
        Validate.isTrue(n18 > 0, "samplesPerPixel must be > 0");
        Validate.isTrue(n18 * n19 <= 16 || n18 * n19 % 16 == 0, "samplesPerPixel * bitsPerSample must be < 16 or a multiple of 16");
        int n26 = n19 * n18 / 16;
        for (int i15 = 0; i15 < n16 * n26; i15 += n25 * n26) {
            System.arraycopy(sArray, n15 + i15, sArray2, n17 + i15 / n25, n26);
        }
    }

    public static void subsampleRow(int[] nArray, int n15, int n16, int[] nArray2, int n17, int n18, int n19, int n25) {
        if (n25 == 1) {
            if (nArray != nArray2) {
                System.arraycopy(nArray, n15, nArray2, n17, n16);
            }
            return;
        }
        Validate.isTrue(n25 > 1, "samplePeriod must be > 1");
        Validate.isTrue(n19 > 0 && n19 <= 32 && (n19 == 1 || n19 % 2 == 0), "bitsPerSample must be > 0 and <= 32 and a power of 2");
        Validate.isTrue(n18 > 0, "samplesPerPixel must be > 0");
        Validate.isTrue(n18 * n19 <= 32 || n18 * n19 % 32 == 0, "samplesPerPixel * bitsPerSample must be < 32 or a multiple of 32");
        int n26 = n19 * n18 / 32;
        for (int i15 = 0; i15 < n16 * n26; i15 += n25 * n26) {
            System.arraycopy(nArray, n15 + i15, nArray2, n17 + i15 / n25, n26);
        }
    }

    public static void subsampleRow(float[] fArray, int n15, int n16, float[] fArray2, int n17, int n18, int n19, int n25) {
        Validate.isTrue(n25 > 1, "samplePeriod must be > 1");
        Validate.isTrue(n19 > 0 && n19 <= 32 && (n19 == 1 || n19 % 2 == 0), "bitsPerSample must be > 0 and <= 32 and a power of 2");
        Validate.isTrue(n18 > 0, "samplesPerPixel must be > 0");
        Validate.isTrue(n18 * n19 <= 32 || n18 * n19 % 32 == 0, "samplesPerPixel * bitsPerSample must be < 32 or a multiple of 32");
        int n26 = n19 * n18 / 32;
        for (int i15 = 0; i15 < n16 * n26; i15 += n25 * n26) {
            System.arraycopy(fArray, n15 + i15, fArray2, n17 + i15 / n25, n26);
        }
    }

    public static void subsampleRow(double[] dArray, int n15, int n16, double[] dArray2, int n17, int n18, int n19, int n25) {
        Validate.isTrue(n25 > 1, "samplePeriod must be > 1");
        Validate.isTrue(n19 > 0 && n19 <= 64 && (n19 == 1 || n19 % 2 == 0), "bitsPerSample must be > 0 and <= 64 and a power of 2");
        Validate.isTrue(n18 > 0, "samplesPerPixel must be > 0");
        Validate.isTrue(n18 * n19 <= 64 || n18 * n19 % 64 == 0, "samplesPerPixel * bitsPerSample must be < 64 or a multiple of 64");
        int n26 = n19 * n18 / 64;
        for (int i15 = 0; i15 < n16 * n26; i15 += n25 * n26) {
            System.arraycopy(dArray, n15 + i15, dArray2, n17 + i15 / n25, n26);
        }
    }
}

