/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public final class SubImageOutputStream
extends ImageOutputStreamImpl {
    private final ImageOutputStream stream;
    private final long startPos;

    public SubImageOutputStream(ImageOutputStream imageOutputStream) throws IOException {
        this.stream = Validate.notNull(imageOutputStream, "stream");
        this.startPos = imageOutputStream.getStreamPosition();
    }

    @Override
    public void seek(long l15) throws IOException {
        super.seek(l15);
        this.stream.seek(this.startPos + l15);
    }

    @Override
    public void write(int n15) throws IOException {
        this.flushBits();
        this.stream.write(n15);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] byArray, int n15, int n16) throws IOException {
        this.flushBits();
        this.stream.write(byArray, n15, n16);
        this.streamPos += (long)n16;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        ++this.streamPos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        this.bitOffset = 0;
        int n17 = this.stream.read(byArray, n15, n16);
        this.streamPos += (long)n17;
        return n17;
    }

    @Override
    public boolean isCached() {
        return this.stream.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.stream.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.stream.isCachedFile();
    }
}

