/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.CharEscaper;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public abstract class ArrayBasedCharEscaper
extends CharEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final char safeMin;
    private final char safeMax;

    protected ArrayBasedCharEscaper(Map<Character, String> replacementMap, char safeMin, char safeMax) {
        this(ArrayBasedEscaperMap.create(replacementMap), safeMin, safeMax);
    }

    protected ArrayBasedCharEscaper(ArrayBasedEscaperMap escaperMap, char safeMin, char safeMax) {
        Preconditions.checkNotNull(escaperMap);
        this.replacements = escaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = '\u0000';
            safeMin = (char)65535;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
    }

    @Override
    public final String escape(String s15) {
        Preconditions.checkNotNull(s15);
        for (int i15 = 0; i15 < s15.length(); ++i15) {
            char c15 = s15.charAt(i15);
            if ((c15 >= this.replacementsLength || this.replacements[c15] == null) && c15 <= this.safeMax && c15 >= this.safeMin) continue;
            return this.escapeSlow(s15, i15);
        }
        return s15;
    }

    @Override
    protected final char @Nullable [] escape(char c15) {
        char[] chars;
        if (c15 < this.replacementsLength && (chars = this.replacements[c15]) != null) {
            return chars;
        }
        if (c15 >= this.safeMin && c15 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(c15);
    }

    protected abstract char @Nullable [] escapeUnsafe(char var1);
}

