/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.Color;

public class HSLColor {
    private final Color rgb;
    private final float[] hsl;
    private final float alpha;

    public HSLColor(Color rgb) {
        this.rgb = rgb;
        this.hsl = HSLColor.fromRGB(rgb);
        this.alpha = (float)rgb.getAlpha() / 255.0f;
    }

    public HSLColor(float h15, float s15, float l15) {
        this(h15, s15, l15, 1.0f);
    }

    public HSLColor(float h15, float s15, float l15, float alpha) {
        this.hsl = new float[]{h15, s15, l15};
        this.alpha = alpha;
        this.rgb = HSLColor.toRGB(this.hsl, alpha);
    }

    public HSLColor(float[] hsl) {
        this(hsl, 1.0f);
    }

    public HSLColor(float[] hsl, float alpha) {
        this.hsl = hsl;
        this.alpha = alpha;
        this.rgb = HSLColor.toRGB(hsl, alpha);
    }

    public Color adjustHue(float degrees) {
        return HSLColor.toRGB(degrees, this.hsl[1], this.hsl[2], this.alpha);
    }

    public Color adjustLuminance(float percent) {
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], percent, this.alpha);
    }

    public Color adjustSaturation(float percent) {
        return HSLColor.toRGB(this.hsl[0], percent, this.hsl[2], this.alpha);
    }

    public Color adjustShade(float percent) {
        float multiplier = (100.0f - percent) / 100.0f;
        float l15 = Math.max(0.0f, this.hsl[2] * multiplier);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], l15, this.alpha);
    }

    public Color adjustTone(float percent) {
        float multiplier = (100.0f + percent) / 100.0f;
        float l15 = Math.min(100.0f, this.hsl[2] * multiplier);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], l15, this.alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getComplementary() {
        float hue = (this.hsl[0] + 180.0f) % 360.0f;
        return HSLColor.toRGB(hue, this.hsl[1], this.hsl[2]);
    }

    public float getHue() {
        return this.hsl[0];
    }

    public float[] getHSL() {
        return this.hsl;
    }

    public float getLuminance() {
        return this.hsl[2];
    }

    public Color getRGB() {
        return this.rgb;
    }

    public float getSaturation() {
        return this.hsl[1];
    }

    public String toString() {
        String toString = "HSLColor[h=" + this.hsl[0] + ",s=" + this.hsl[1] + ",l=" + this.hsl[2] + ",alpha=" + this.alpha + "]";
        return toString;
    }

    public static float[] fromRGB(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        float r15 = rgb[0];
        float g15 = rgb[1];
        float b15 = rgb[2];
        float min = Math.min(r15, Math.min(g15, b15));
        float max = Math.max(r15, Math.max(g15, b15));
        float h15 = 0.0f;
        if (max == min) {
            h15 = 0.0f;
        } else if (max == r15) {
            h15 = (60.0f * (g15 - b15) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g15) {
            h15 = 60.0f * (b15 - r15) / (max - min) + 120.0f;
        } else if (max == b15) {
            h15 = 60.0f * (r15 - g15) / (max - min) + 240.0f;
        }
        float l15 = (max + min) / 2.0f;
        float s15 = max == min ? 0.0f : (l15 <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h15, s15 * 100.0f, l15 * 100.0f};
    }

    public static Color toRGB(float[] hsl) {
        return HSLColor.toRGB(hsl, 1.0f);
    }

    public static Color toRGB(float[] hsl, float alpha) {
        return HSLColor.toRGB(hsl[0], hsl[1], hsl[2], alpha);
    }

    public static Color toRGB(float h15, float s15, float l15) {
        return HSLColor.toRGB(h15, s15, l15, 1.0f);
    }

    public static Color toRGB(float h15, float s15, float l15, float alpha) {
        if (s15 < 0.0f || s15 > 100.0f) {
            String message2 = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message2);
        }
        if (l15 < 0.0f || l15 > 100.0f) {
            String message3 = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message3);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            String message4 = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message4);
        }
        h15 %= 360.0f;
        float q15 = (double)(l15 /= 100.0f) < 0.5 ? l15 * (1.0f + s15) : l15 + (s15 /= 100.0f) - s15 * l15;
        float p15 = 2.0f * l15 - q15;
        float r15 = Math.max(0.0f, HSLColor.HueToRGB(p15, q15, (h15 /= 360.0f) + 0.33333334f));
        float g15 = Math.max(0.0f, HSLColor.HueToRGB(p15, q15, h15));
        float b15 = Math.max(0.0f, HSLColor.HueToRGB(p15, q15, h15 - 0.33333334f));
        r15 = Math.min(r15, 1.0f);
        g15 = Math.min(g15, 1.0f);
        b15 = Math.min(b15, 1.0f);
        return new Color(r15, g15, b15, alpha);
    }

    private static float HueToRGB(float p15, float q15, float h15) {
        if (h15 < 0.0f) {
            h15 += 1.0f;
        }
        if (h15 > 1.0f) {
            h15 -= 1.0f;
        }
        if (6.0f * h15 < 1.0f) {
            return p15 + (q15 - p15) * 6.0f * h15;
        }
        if (2.0f * h15 < 1.0f) {
            return q15;
        }
        if (3.0f * h15 < 2.0f) {
            return p15 + (q15 - p15) * 6.0f * (0.6666667f - h15);
        }
        return p15;
    }
}

