/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;

public class CubicBezierEasing
implements Animator.Interpolator {
    public static final CubicBezierEasing STANDARD_EASING = new CubicBezierEasing(0.4f, 0.0f, 0.2f, 1.0f);
    public static final CubicBezierEasing EASE = new CubicBezierEasing(0.25f, 0.1f, 0.25f, 1.0f);
    public static final CubicBezierEasing EASE_IN = new CubicBezierEasing(0.42f, 0.0f, 1.0f, 1.0f);
    public static final CubicBezierEasing EASE_IN_OUT = new CubicBezierEasing(0.42f, 0.0f, 0.58f, 1.0f);
    public static final CubicBezierEasing EASE_OUT = new CubicBezierEasing(0.0f, 0.0f, 0.58f, 1.0f);
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    public CubicBezierEasing(float x15, float y15, float x25, float y25) {
        if (x15 < 0.0f || x15 > 1.0f || y15 < 0.0f || y15 > 1.0f || x25 < 0.0f || x25 > 1.0f || y25 < 0.0f || y25 > 1.0f) {
            throw new IllegalArgumentException("control points must be in range [0, 1]");
        }
        this.x1 = x15;
        this.y1 = y15;
        this.x2 = x25;
        this.y2 = y25;
    }

    @Override
    public float interpolate(float fraction) {
        if (fraction <= 0.0f || fraction >= 1.0f) {
            return fraction;
        }
        float low = 0.0f;
        float high = 1.0f;
        float mid;
        float estimate;
        while (!(Math.abs(fraction - (estimate = CubicBezierEasing.cubicBezier(mid = (low + high) / 2.0f, this.x1, this.x2))) < 5.0E-4f)) {
            if (estimate < fraction) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return CubicBezierEasing.cubicBezier(mid, this.y1, this.y2);
    }

    private static float cubicBezier(float t15, float xy12, float xy22) {
        float invT = 1.0f - t15;
        float b15 = 3.0f * t15 * (invT * invT);
        float b25 = 3.0f * (t15 * t15) * invT;
        float b35 = t15 * t15 * t15;
        return b15 * xy12 + b25 * xy22 + b35;
    }
}

