/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TableUI;

public class FlatTableCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("Table.showCellFocusIndicator");
    private Component c;

    protected FlatTableCellBorder() {
        super(UIManager.getInsets("Table.cellMargins"), UIManager.getColor("Table.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        Insets m15 = FlatTableCellBorder.getStyleFromTableUI(c15, ui4 -> ui4.cellMargins);
        if (m15 != null) {
            return FlatTableCellBorder.scaleInsets(c15, insets, m15.top, m15.left, m15.bottom, m15.right);
        }
        return super.getBorderInsets(c15, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatTableCellBorder.getStyleFromTableUI(this.c, ui4 -> ui4.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public int getArc() {
        Integer selectionArc;
        if (this.c != null && (selectionArc = FlatTableCellBorder.getStyleFromTableUI(this.c, ui4 -> ui4.selectionArc)) != null) {
            return selectionArc;
        }
        return super.getArc();
    }

    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        Insets selectionInsets;
        if (c15 != null && (selectionInsets = FlatTableCellBorder.getStyleFromTableUI(c15, ui4 -> ui4.selectionInsets)) != null) {
            x15 += selectionInsets.left;
            y15 += selectionInsets.top;
            width -= selectionInsets.left + selectionInsets.right;
            height -= selectionInsets.top + selectionInsets.bottom;
        }
        this.c = c15;
        super.paintBorder(c15, g15, x15, y15, width, height);
        this.c = null;
    }

    static <T> T getStyleFromTableUI(Component c15, Function<FlatTableUI, T> f15) {
        TableUI ui4;
        JTable table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c15);
        if (table != null && (ui4 = table.getUI()) instanceof FlatTableUI) {
            return f15.apply((FlatTableUI)ui4);
        }
        return null;
    }

    public static class Selected
    extends FlatTableCellBorder {
        public int maxCheckCellsEditable = 50;

        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
            JTable table;
            boolean showCellFocusIndicator;
            Boolean b15 = Selected.getStyleFromTableUI(c15, ui4 -> ui4.showCellFocusIndicator);
            boolean bl4 = showCellFocusIndicator = b15 != null ? b15 : this.showCellFocusIndicator;
            if (!showCellFocusIndicator && (table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c15)) != null && !this.shouldShowCellFocusIndicator(table)) {
                return;
            }
            super.paintBorder(c15, g15, x15, y15, width, height);
        }

        protected boolean shouldShowCellFocusIndicator(JTable table) {
            block8: {
                boolean columnSelectionAllowed;
                block7: {
                    boolean rowSelectionAllowed = table.getRowSelectionAllowed();
                    columnSelectionAllowed = table.getColumnSelectionAllowed();
                    if (rowSelectionAllowed && columnSelectionAllowed) {
                        return false;
                    }
                    if (!rowSelectionAllowed) break block7;
                    if (table.getSelectedRowCount() != 1) {
                        return false;
                    }
                    int columnCount = table.getColumnCount();
                    if (columnCount > this.maxCheckCellsEditable) {
                        return true;
                    }
                    int selectedRow = table.getSelectedRow();
                    for (int column = 0; column < columnCount; ++column) {
                        if (!table.isCellEditable(selectedRow, column)) continue;
                        return true;
                    }
                    break block8;
                }
                if (!columnSelectionAllowed) break block8;
                if (table.getSelectedColumnCount() != 1) {
                    return false;
                }
                int rowCount = table.getRowCount();
                if (rowCount > this.maxCheckCellsEditable) {
                    return true;
                }
                int selectedColumn = table.getSelectedColumn();
                for (int row = 0; row < rowCount; ++row) {
                    if (!table.isCellEditable(row, selectedColumn)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class Focused
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
            Border border;
            JTable table;
            if (c15 != null && c15.getClass().getName().equals("javax.swing.JTable$BooleanRenderer") && (table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c15)) != null && c15.getForeground() == table.getSelectionForeground() && c15.getBackground() == table.getSelectionBackground() && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                border.paintBorder(c15, g15, x15, y15, width, height);
                return;
            }
            super.paintBorder(c15, g15, x15, y15, width, height);
        }
    }

    public static class Default
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        }
    }
}

