/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.Hex;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Utf8Utils {
    private static final ThreadLocal<char[]> localBuffer = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i15 = 0; i15 < len; ++i15) {
            char c15 = string.charAt(i15);
            if (c15 != '\u0000' && c15 < '\u0080') {
                bytes[outAt] = (byte)c15;
                ++outAt;
                continue;
            }
            if (c15 < '\u0800') {
                bytes[outAt] = (byte)(c15 >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c15 & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c15 >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c15 >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c15 & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(byte[] bytes, int start, int length) {
        char[] chars = localBuffer.get();
        if (chars == null || chars.length < length) {
            chars = new char[length];
            localBuffer.set(chars);
        }
        int outAt = 0;
        int at4 = start;
        while (length > 0) {
            char out;
            int v05 = bytes[at4] & 0xFF;
            switch (v05 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v05 == 0) {
                        return Utf8Utils.throwBadUtf8(v05, at4);
                    }
                    out = (char)v05;
                    ++at4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(v05, at4);
                    }
                    int v15 = bytes[at4 + 1] & 0xFF;
                    if ((v15 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v15, at4 + 1);
                    }
                    int value = (v05 & 0x1F) << 6 | v15 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v15, at4 + 1);
                    }
                    out = (char)value;
                    at4 += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(v05, at4);
                    }
                    int v15 = bytes[at4 + 1] & 0xFF;
                    if ((v15 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v15, at4 + 1);
                    }
                    int v25 = bytes[at4 + 2] & 0xFF;
                    if ((v25 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v25, at4 + 2);
                    }
                    int value = (v05 & 0xF) << 12 | (v15 & 0x3F) << 6 | v25 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v25, at4 + 2);
                    }
                    out = (char)value;
                    at4 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v05, at4);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    public static String utf8BytesWithUtf16LengthToString(@Nonnull byte[] bytes, int start, int utf16Length) {
        return Utf8Utils.utf8BytesWithUtf16LengthToString(bytes, start, utf16Length, null);
    }

    public static String utf8BytesWithUtf16LengthToString(@Nonnull byte[] bytes, int start, int utf16Length, @Nullable int[] readLength) {
        char[] chars = localBuffer.get();
        if (chars == null || chars.length < utf16Length) {
            chars = new char[utf16Length];
            localBuffer.set(chars);
        }
        int outAt = 0;
        int at4 = 0;
        at4 = start;
        while (utf16Length > 0) {
            char out;
            int v05 = bytes[at4] & 0xFF;
            switch (v05 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (v05 == 0) {
                        return Utf8Utils.throwBadUtf8(v05, at4);
                    }
                    out = (char)v05;
                    ++at4;
                    break;
                }
                case 12: 
                case 13: {
                    int v15 = bytes[at4 + 1] & 0xFF;
                    if ((v15 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v15, at4 + 1);
                    }
                    int value = (v05 & 0x1F) << 6 | v15 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v15, at4 + 1);
                    }
                    out = (char)value;
                    at4 += 2;
                    break;
                }
                case 14: {
                    int v15 = bytes[at4 + 1] & 0xFF;
                    if ((v15 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v15, at4 + 1);
                    }
                    int v25 = bytes[at4 + 2] & 0xFF;
                    if ((v25 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v25, at4 + 2);
                    }
                    int value = (v05 & 0xF) << 12 | (v15 & 0x3F) << 6 | v25 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v25, at4 + 2);
                    }
                    out = (char)value;
                    at4 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v05, at4);
                }
            }
            chars[outAt] = out;
            ++outAt;
            --utf16Length;
        }
        if (readLength != null && readLength.length > 0) {
            readLength[0] = at4 - start;
            readLength[0] = at4 - start;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(value) + " at offset " + Hex.u4(offset));
    }
}

