/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.stream.Stream;

public class ResourceAnalyzer {
    private final AppBundle appBundle;
    private final ImmutableMap<ResourceId, ResourceTableEntry> baseModuleResourcesById;

    public ResourceAnalyzer(AppBundle appBundle) {
        this.appBundle = appBundle;
        this.baseModuleResourcesById = ResourceAnalyzer.buildBaseModuleResourcesByIdMap(appBundle);
    }

    public ImmutableSet<ResourceId> findAllAppResourcesReachableFromBaseManifest() throws IOException {
        return this.findAllAppResourcesReachableFromManifest(this.appBundle.getBaseModule().getAndroidManifest());
    }

    public ImmutableSet<ResourceId> findAllAppResourcesReachableFromManifest(AndroidManifest androidManifest) throws IOException {
        ImmutableSet<ResourceId> resourceIdsInManifest = this.findAllReferencedAppResources(androidManifest.getManifestRoot().getProto());
        return this.transitiveClosure(resourceIdsInManifest);
    }

    private ImmutableSet<ResourceId> transitiveClosure(ImmutableSet<ResourceId> anchorResources) throws IOException {
        HashSet<ResourceId> referencedResources = new HashSet<ResourceId>();
        ArrayDeque<ResourceId> resourcesToInspect = new ArrayDeque<ResourceId>();
        resourcesToInspect.addAll(anchorResources);
        while (!resourcesToInspect.isEmpty()) {
            ResourceId resourceId = (ResourceId)resourcesToInspect.remove();
            if (referencedResources.contains(resourceId) || !this.baseModuleResourcesById.containsKey(resourceId)) continue;
            referencedResources.add(resourceId);
            ResourceTableEntry resourceEntry = this.baseModuleResourcesById.get(resourceId);
            for (Resources.ConfigValue configValue : resourceEntry.getEntry().getConfigValueList()) {
                switch (configValue.getValue().getValueCase()) {
                    case ITEM: {
                        Resources.Item item = configValue.getValue().getItem();
                        resourcesToInspect.addAll(this.findAllReferencedAppResources(item));
                        break;
                    }
                    case COMPOUND_VALUE: {
                        Resources.CompoundValue compoundValue = configValue.getValue().getCompoundValue();
                        resourcesToInspect.addAll(this.findAllReferencedAppResources(compoundValue));
                        break;
                    }
                }
            }
        }
        return ImmutableSet.copyOf(referencedResources);
    }

    private ImmutableSet<ResourceId> findAllReferencedAppResources(Resources.XmlNode xmlRoot) {
        return ResourceAnalyzer.getAllAttributesRecursively(xmlRoot.getElement()).filter(Resources.XmlAttribute::hasCompiledItem).map(Resources.XmlAttribute::getCompiledItem).flatMap(item -> this.findAllReferencedAppResources((Resources.Item)item).stream()).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImmutableSet<ResourceId> findAllReferencedAppResources(Resources.Item item) {
        switch (item.getValueCase()) {
            case REF: {
                if (item.getRef().getId() == 0) return ImmutableSet.of();
                return ImmutableSet.of(ResourceId.create(item.getRef().getId()));
            }
            case FILE: {
                ImmutableSet<ResourceId> immutableSet;
                Resources.FileReference fileRef = item.getFile();
                if (!fileRef.getType().equals(Resources.FileReference.Type.PROTO_XML)) {
                    return ImmutableSet.of();
                }
                ZipPath xmlResourcePath = ZipPath.create(fileRef.getPath());
                InputStream is4 = this.appBundle.getBaseModule().getEntry(xmlResourcePath).get().getContent().openStream();
                try {
                    Resources.XmlNode xmlRoot = Resources.XmlNode.parseFrom(is4);
                    immutableSet = this.findAllReferencedAppResources(xmlRoot);
                    if (is4 == null) return immutableSet;
                }
                catch (Throwable throwable) {
                    try {
                        if (is4 == null) throw throwable;
                        try {
                            is4.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (InvalidProtocolBufferException e15) {
                        throw CommandExecutionException.builder().withInternalMessage("Error parsing XML file '%s'.", xmlResourcePath).withCause(e15).build();
                    }
                    catch (IOException e16) {
                        throw new UncheckedIOException(String.format("Failed to parse file '%s' in base module.", xmlResourcePath), e16);
                    }
                }
                is4.close();
                return immutableSet;
            }
        }
        return ImmutableSet.of();
    }

    private ImmutableSet<ResourceId> findAllReferencedAppResources(Resources.CompoundValue compoundValue) {
        switch (compoundValue.getValueCase()) {
            case ATTR: {
                return compoundValue.getAttr().getSymbolList().stream().map(symbol -> symbol.getName().getId()).filter(id5 -> id5 != 0).map(ResourceId::create).collect(ImmutableSet.toImmutableSet());
            }
            case STYLE: {
                ImmutableSet.Builder referencedResources = ImmutableSet.builder();
                if (compoundValue.getStyle().getParent().getId() != 0) {
                    referencedResources.add(ResourceId.create(compoundValue.getStyle().getParent().getId()));
                }
                for (Resources.Style.Entry entry : compoundValue.getStyle().getEntryList()) {
                    referencedResources.addAll(this.findAllReferencedAppResources(entry.getItem()));
                    if (entry.getKey().getId() == 0) continue;
                    referencedResources.add(ResourceId.create(entry.getKey().getId()));
                }
                return referencedResources.build();
            }
        }
        return ImmutableSet.of();
    }

    private static Stream<Resources.XmlAttribute> getAllAttributesRecursively(Resources.XmlElement element) {
        return Stream.concat(element.getAttributeList().stream(), element.getChildList().stream().filter(node -> node.hasElement()).flatMap(node -> ResourceAnalyzer.getAllAttributesRecursively(node.getElement())));
    }

    private static ImmutableMap<ResourceId, ResourceTableEntry> buildBaseModuleResourcesByIdMap(AppBundle appBundle) {
        if (!appBundle.getBaseModule().getResourceTable().isPresent()) {
            return ImmutableMap.of();
        }
        return ResourcesUtils.entries(appBundle.getBaseModule().getResourceTable().get()).collect(ImmutableMap.toImmutableMap(ResourceTableEntry::getResourceId, entry -> entry));
    }
}

