/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceState;
import ch.qos.logback.core.util.CharSequenceToRegexMapper;
import java.util.ArrayList;
import java.util.List;

public class DatePatternToRegexUtil {
    final String datePattern;
    final int datePatternLength;
    final CharSequenceToRegexMapper regexMapper = new CharSequenceToRegexMapper();

    public DatePatternToRegexUtil(String datePattern) {
        this.datePattern = datePattern;
        this.datePatternLength = datePattern.length();
    }

    public String toRegex() {
        List<CharSequenceState> charSequenceList = this.tokenize();
        StringBuilder sb5 = new StringBuilder();
        for (CharSequenceState seq : charSequenceList) {
            sb5.append(this.regexMapper.toRegex(seq));
        }
        return sb5.toString();
    }

    private List<CharSequenceState> tokenize() {
        ArrayList<CharSequenceState> sequenceList = new ArrayList<CharSequenceState>();
        CharSequenceState lastCharSequenceState = null;
        for (int i15 = 0; i15 < this.datePatternLength; ++i15) {
            char t15 = this.datePattern.charAt(i15);
            if (lastCharSequenceState == null || lastCharSequenceState.c != t15) {
                lastCharSequenceState = new CharSequenceState(t15);
                sequenceList.add(lastCharSequenceState);
                continue;
            }
            lastCharSequenceState.incrementOccurrences();
        }
        return sequenceList;
    }
}

