/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Token;

class TokenQueue {
    private Token[] buffer;
    private int sizeLessOne;
    private int offset;
    protected int nbrEntries;

    public TokenQueue(int n15) {
        int n16;
        if (n15 < 0) {
            this.init(16);
            return;
        }
        if (n15 >= 0x3FFFFFFF) {
            this.init(Integer.MAX_VALUE);
            return;
        }
        for (n16 = 2; n16 < n15; n16 *= 2) {
        }
        this.init(n16);
    }

    public final void append(Token token) {
        if (this.nbrEntries == this.buffer.length) {
            this.expand();
        }
        this.buffer[this.offset + this.nbrEntries & this.sizeLessOne] = token;
        ++this.nbrEntries;
    }

    public final Token elementAt(int n15) {
        return this.buffer[this.offset + n15 & this.sizeLessOne];
    }

    private final void expand() {
        Token[] tokenArray = new Token[this.buffer.length * 2];
        for (int i15 = 0; i15 < this.buffer.length; ++i15) {
            tokenArray[i15] = this.elementAt(i15);
        }
        this.buffer = tokenArray;
        this.sizeLessOne = this.buffer.length - 1;
        this.offset = 0;
    }

    private final void init(int n15) {
        this.buffer = new Token[n15];
        this.sizeLessOne = n15 - 1;
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void reset() {
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void removeFirst() {
        this.offset = this.offset + 1 & this.sizeLessOne;
        --this.nbrEntries;
    }
}

