﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/ConsolidatedReportMetric.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {
class GetConsolidatedReportResult {
 public:
  AWS_WELLARCHITECTED_API GetConsolidatedReportResult() = default;
  AWS_WELLARCHITECTED_API GetConsolidatedReportResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WELLARCHITECTED_API GetConsolidatedReportResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The metrics that make up the consolidated report.</p> <p>Only returned when
   * <code>JSON</code> format is requested.</p>
   */
  inline const Aws::Vector<ConsolidatedReportMetric>& GetMetrics() const { return m_metrics; }
  template <typename MetricsT = Aws::Vector<ConsolidatedReportMetric>>
  void SetMetrics(MetricsT&& value) {
    m_metricsHasBeenSet = true;
    m_metrics = std::forward<MetricsT>(value);
  }
  template <typename MetricsT = Aws::Vector<ConsolidatedReportMetric>>
  GetConsolidatedReportResult& WithMetrics(MetricsT&& value) {
    SetMetrics(std::forward<MetricsT>(value));
    return *this;
  }
  template <typename MetricsT = ConsolidatedReportMetric>
  GetConsolidatedReportResult& AddMetrics(MetricsT&& value) {
    m_metricsHasBeenSet = true;
    m_metrics.emplace_back(std::forward<MetricsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetConsolidatedReportResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetBase64String() const { return m_base64String; }
  template <typename Base64StringT = Aws::String>
  void SetBase64String(Base64StringT&& value) {
    m_base64StringHasBeenSet = true;
    m_base64String = std::forward<Base64StringT>(value);
  }
  template <typename Base64StringT = Aws::String>
  GetConsolidatedReportResult& WithBase64String(Base64StringT&& value) {
    SetBase64String(std::forward<Base64StringT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetConsolidatedReportResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ConsolidatedReportMetric> m_metrics;

  Aws::String m_nextToken;

  Aws::String m_base64String;

  Aws::String m_requestId;
  bool m_metricsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_base64StringHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
