﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/BotAliasSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class ListBotAliasesResult {
 public:
  AWS_LEXMODELSV2_API ListBotAliasesResult() = default;
  AWS_LEXMODELSV2_API ListBotAliasesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API ListBotAliasesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Summary information for the bot aliases that meet the filter criteria
   * specified in the request. The length of the list is specified in the
   * <code>maxResults</code> parameter of the request. If there are more aliases
   * available, the <code>nextToken</code> field contains a token to get the next
   * page of results.</p>
   */
  inline const Aws::Vector<BotAliasSummary>& GetBotAliasSummaries() const { return m_botAliasSummaries; }
  template <typename BotAliasSummariesT = Aws::Vector<BotAliasSummary>>
  void SetBotAliasSummaries(BotAliasSummariesT&& value) {
    m_botAliasSummariesHasBeenSet = true;
    m_botAliasSummaries = std::forward<BotAliasSummariesT>(value);
  }
  template <typename BotAliasSummariesT = Aws::Vector<BotAliasSummary>>
  ListBotAliasesResult& WithBotAliasSummaries(BotAliasSummariesT&& value) {
    SetBotAliasSummaries(std::forward<BotAliasSummariesT>(value));
    return *this;
  }
  template <typename BotAliasSummariesT = BotAliasSummary>
  ListBotAliasesResult& AddBotAliasSummaries(BotAliasSummariesT&& value) {
    m_botAliasSummariesHasBeenSet = true;
    m_botAliasSummaries.emplace_back(std::forward<BotAliasSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates whether there are more results to return in a response
   * to the <code>ListBotAliases</code> operation. If the <code>nextToken</code>
   * field is present, you send the contents as the <code>nextToken</code> parameter
   * of a <code>ListBotAliases</code> operation request to get the next page of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListBotAliasesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the bot associated with the aliases.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  ListBotAliasesResult& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListBotAliasesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<BotAliasSummary> m_botAliasSummaries;

  Aws::String m_nextToken;

  Aws::String m_botId;

  Aws::String m_requestId;
  bool m_botAliasSummariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_botIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
