/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cpe.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ConfigParameterModel {
    private ConfigurationParameter configParam;
    private Object value;
    private Object cpeValue = null;

    public ConfigParameterModel(ConfigurationParameter configParam) {
        this.configParam = configParam;
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        if (this.getCpeValue() == null) {
            Trace.trace("No value");
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "nameValuePair", attrs);
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "name", attrs);
        String valStr = this.getName();
        aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "name");
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "value", attrs);
        String lowerCaseType = this.getType().toLowerCase();
        if (this.isMultiValued()) {
            aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "array", attrs);
            Object[] v = (Object[])this.getCpeValue();
            for (int i = 0; i < v.length; ++i) {
                aContentHandler.startElement(this.getXmlizationInfo().namespace, "", lowerCaseType, attrs);
                valStr = "" + v[i];
                aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
                aContentHandler.endElement(this.getXmlizationInfo().namespace, "", lowerCaseType);
            }
        } else {
            aContentHandler.startElement(this.getXmlizationInfo().namespace, "", lowerCaseType, attrs);
            valStr = "" + this.getCpeValue();
            aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
            aContentHandler.endElement(this.getXmlizationInfo().namespace, "", lowerCaseType);
        }
        if (this.isMultiValued()) {
            aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "array");
        }
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "value");
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "nameValuePair");
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void cloneValue() {
    }

    public int getMultivalueSize() {
        if (this.value == null) {
            return 0;
        }
        if (!this.isMultiValued()) {
            return 1;
        }
        return ((Object[])this.value).length;
    }

    public int getCpeValueSize() {
        if (this.cpeValue == null) {
            return 0;
        }
        if (!this.isMultiValued()) {
            return 1;
        }
        return ((Object[])this.cpeValue).length;
    }

    public Object getCpeValue() {
        if (this.cpeValue != null && this.getCpeValueSize() > 0) {
            return this.cpeValue;
        }
        return null;
    }

    public void setCpeValue(Object cpeValue) {
        this.cpeValue = cpeValue;
    }

    public void setCpeValue(String aValueString) {
        if (!this.isMultiValued()) {
            this.setCpeValue(this.getValueObjectFromString(aValueString));
        } else {
            this.addValueToCpeMultivalue(aValueString);
        }
    }

    public Object getValueObjectFromString(String aValueString) {
        if (aValueString == null || aValueString.trim().length() == 0) {
            return null;
        }
        Object aValue = null;
        String paramType = this.getType();
        try {
            if ("String".equals(paramType)) {
                aValue = aValueString;
            } else if ("Integer".equals(paramType)) {
                aValue = Integer.valueOf(aValueString);
            } else if ("Float".equals(paramType)) {
                aValue = Float.valueOf(aValueString);
            } else if ("Boolean".equals(paramType)) {
                aValue = Boolean.valueOf(aValueString);
            } else {
                Trace.bug("Wrong param type: " + paramType);
            }
        }
        catch (NumberFormatException e) {
            Trace.err(e.toString());
        }
        return aValue;
    }

    private Object _insertValueToMultivalue(Object[] v, Object aValue, int atIndex) {
        Object[] newValues;
        if (v != null) {
            int i;
            newValues = new Object[v.length + 1];
            for (i = 0; i < atIndex; ++i) {
                newValues[i] = v[i];
            }
            newValues[atIndex] = aValue;
            for (i = atIndex; i < v.length; ++i) {
                newValues[i + 1] = v[i];
            }
        } else {
            newValues = new Object[]{aValue};
        }
        return newValues;
    }

    public void addValueToMultivalue(String aValueString, int atIndex) {
        if (!this.isMultiValued()) {
            return;
        }
        this.value = this._insertValueToMultivalue((Object[])this.value, this.getValueObjectFromString(aValueString), atIndex);
    }

    public void addValueToCpeMultivalue(String aValueString, int atIndex) {
        if (!this.isMultiValued()) {
            return;
        }
        this.cpeValue = this._insertValueToMultivalue((Object[])this.cpeValue, this.getValueObjectFromString(aValueString), atIndex);
    }

    public void addValueToMultivalue(String aValueString) {
        Object[] newValues;
        if (!this.isMultiValued()) {
            return;
        }
        Object aValue = this.getValueObjectFromString(aValueString);
        Object[] v = (Object[])this.getValue();
        if (v != null) {
            newValues = new Object[v.length + 1];
            for (int i = 0; i < v.length; ++i) {
                newValues[i] = v[i];
            }
            newValues[v.length] = aValue;
        } else {
            newValues = new Object[]{aValue};
        }
        this.setValue(newValues);
    }

    public void addValueToCpeMultivalue(String aValueString) {
        Object[] newValues;
        if (!this.isMultiValued()) {
            return;
        }
        Object aValue = this.getValueObjectFromString(aValueString);
        Object[] v = (Object[])this.cpeValue;
        if (v != null) {
            newValues = new Object[v.length + 1];
            for (int i = 0; i < v.length; ++i) {
                newValues[i] = v[i];
            }
            newValues[v.length] = aValue;
        } else {
            newValues = new Object[]{aValue};
        }
        this.setCpeValue(newValues);
    }

    private Object _removeMultivalue(Object[] v, MultiValues mv) {
        int i;
        if (v.length == 1) {
            return null;
        }
        int index = mv.getIndex();
        Object[] newValues = new Object[v.length - 1];
        for (i = 0; i < index; ++i) {
            newValues[i] = v[i];
        }
        for (i = index; i < v.length - 1; ++i) {
            newValues[i] = v[i + 1];
        }
        return newValues;
    }

    public void removeMultivalue(MultiValues mv) {
        if (!this.isMultiValued()) {
            return;
        }
        this.value = this._removeMultivalue((Object[])this.value, mv);
    }

    public void removeCpeMultivalue(MultiValues mv) {
        if (!this.isMultiValued()) {
            return;
        }
        this.cpeValue = this._removeMultivalue((Object[])this.cpeValue, mv);
    }

    private boolean moveMultivalue(boolean moveUp, Object[] v, int index) {
        if (!this.isMultiValued()) {
            return false;
        }
        if (v != null && index < v.length) {
            if (moveUp) {
                if (index > 0) {
                    Object aValue = v[index];
                    v[index] = v[index - 1];
                    v[index - 1] = aValue;
                    return true;
                }
            } else if (index < v.length - 1) {
                Object aValue = v[index];
                v[index] = v[index + 1];
                v[index + 1] = aValue;
                return true;
            }
        }
        return false;
    }

    public boolean moveValue(boolean moveUp, int index) {
        return this.moveMultivalue(moveUp, (Object[])this.value, index);
    }

    public boolean moveCpeValue(boolean moveUp, int index) {
        return this.moveMultivalue(moveUp, (Object[])this.cpeValue, index);
    }

    public void addOverride(String arg0) {
        this.configParam.addOverride(arg0);
    }

    public void buildFromXMLElement(Element arg0, XMLParser arg1, XMLParser.ParsingOptions arg2) throws InvalidXMLException {
        this.configParam.buildFromXMLElement(arg0, arg1, arg2);
    }

    public void buildFromXMLElement(Element arg0, XMLParser arg1) throws InvalidXMLException {
        this.configParam.buildFromXMLElement(arg0, arg1);
    }

    public Object clone() {
        return this.configParam.clone();
    }

    public boolean equals(Object arg0) {
        return this.configParam.equals(arg0);
    }

    public Object getAttributeValue(String arg0) {
        return this.configParam.getAttributeValue(arg0);
    }

    public String getDescription() {
        return this.configParam.getDescription();
    }

    public String getName() {
        return this.configParam.getName();
    }

    public String[] getOverrides() {
        return this.configParam.getOverrides();
    }

    public String getType() {
        return this.configParam.getType();
    }

    public boolean isMandatory() {
        return this.configParam.isMandatory();
    }

    public boolean isModifiable() {
        return this.configParam.isModifiable();
    }

    public boolean isMultiValued() {
        return this.configParam.isMultiValued();
    }

    public List listAttributes() {
        return this.configParam.listAttributes();
    }

    public void removeOverride(String arg0) {
        this.configParam.removeOverride(arg0);
    }

    public void setAttributeValue(String arg0, Object arg1) {
        this.configParam.setAttributeValue(arg0, arg1);
    }

    public void setDescription(String arg0) {
        this.configParam.setDescription(arg0);
    }

    public void setMandatory(boolean arg0) {
        this.configParam.setMandatory(arg0);
    }

    public void setMultiValued(boolean arg0) {
        this.configParam.setMultiValued(arg0);
    }

    public void setName(String arg0) {
        this.configParam.setName(arg0);
    }

    public void setOverrides(String[] arg0) {
        this.configParam.setOverrides(arg0);
    }

    public void setType(String arg0) {
        this.configParam.setType(arg0);
    }

    public void toXML(ContentHandler arg0) throws SAXException {
        this.configParam.toXML(arg0);
    }

    public void toXML(OutputStream arg0) throws SAXException, IOException {
        this.configParam.toXML(arg0);
    }

    public void toXML(Writer arg0) throws SAXException, IOException {
        this.configParam.toXML(arg0);
    }

    public static class MultiValues {
        public ConfigParameterModel parameterModel;
        public Object[] values;
        public int index;

        public MultiValues(ConfigParameterModel paramModel, boolean forCpe, int index) {
            this.parameterModel = paramModel;
            this.index = index;
        }

        public MultiValues(ConfigParameterModel paramModel, Object[] values, int index) {
            this.parameterModel = paramModel;
            this.values = values;
            this.index = index;
        }

        public String getType() {
            return this.parameterModel.getType();
        }

        public String getName() {
            return this.parameterModel.getName();
        }

        public Object getDefValue() {
            return this.values[this.index];
        }

        public void setDefValue(Object value) {
            this.values[this.index] = value;
        }

        public Object getCpeValue() {
            Object[] cpeValues = (Object[])this.parameterModel.getCpeValue();
            if (cpeValues == null) {
                return null;
            }
            return cpeValues[this.index];
        }

        public void setCpeValue(Object value) {
            Object[] cpeValues = (Object[])this.parameterModel.getCpeValue();
            cpeValues[this.index] = value;
        }

        public int getIndex() {
            return this.index;
        }

        public int getMultiValuesSize() {
            Object[] cpeValues = (Object[])this.parameterModel.getCpeValue();
            if (cpeValues == null) {
                Trace.err(this.getName() + ": getMultiValuesSize = 0");
                return 0;
            }
            return cpeValues.length;
        }

        public ConfigParameterModel getParameterModel() {
            return this.parameterModel;
        }

        public void setParameterModel(ConfigParameterModel parameterModel) {
            this.parameterModel = parameterModel;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

