/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import java.util.List;
import org.apache.uima.ruta.cde.ui.ConstraintSelectComposite;
import org.apache.uima.ruta.cde.ui.ConstraintSelectView;
import org.apache.uima.ruta.cde.utils.ConstraintData;
import org.apache.uima.ruta.cde.utils.ConstraintXMLUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportConstraintsHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ConstraintSelectView constraintView = (ConstraintSelectView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.apache.uima.ruta.cde.ui.ConstraintSelectView");
            ConstraintSelectComposite composite = constraintView.getComposite();
            FileDialog dlg = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 4096);
            String[] extensions = new String[]{"*.xml"};
            dlg.setFilterExtensions(extensions);
            String s = dlg.open();
            if (s == null) {
                return Status.CANCEL_STATUS;
            }
            ImportJob job = new ImportJob(event, composite, s);
            job.schedule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private class ImportJob
    extends Job {
        String inputLocation;
        ConstraintSelectComposite composite;

        public ImportJob(ExecutionEvent event, ConstraintSelectComposite composite, String inputLocation) {
            super("Importing constraints");
            this.inputLocation = inputLocation;
            this.composite = composite;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                final List<ConstraintData> constraints = ConstraintXMLUtils.readConstraints(this.inputLocation);
                this.composite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImportJob.this.composite.getConstraintList().addAll(constraints);
                        ImportJob.this.composite.getViewer().setInput(ImportJob.this.composite.getConstraintList());
                        ImportJob.this.composite.getViewer().refresh();
                        ImportJob.this.composite.update();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }
}

