/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.check.AnnotationCheckContentProvider;
import org.apache.uima.ruta.check.AnnotationCheckLabelProvider;
import org.apache.uima.ruta.check.AnnotationCheckRootNode;
import org.apache.uima.ruta.check.AnnotationCheckTreeNode;
import org.apache.uima.ruta.check.AnnotationCheckTreeNodeComparator;
import org.apache.uima.ruta.check.AnnotationCheckView;
import org.apache.uima.ruta.check.CheckAnnotation;
import org.apache.uima.ruta.check.CheckAnnotationDocumentListener;
import org.apache.uima.ruta.check.CheckAnnotationUtils;
import org.apache.uima.ruta.check.CheckDocument;
import org.apache.uima.ruta.check.CheckElement;
import org.apache.uima.ruta.check.IAnnotationCheckTreeNode;
import org.apache.uima.ruta.check.XMLUtils;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.xml.sax.SAXException;

public class AnnotationCheckComposite
extends Composite
implements ISelectionChangedListener,
ISelectionListener {
    private CheckAnnotationDocumentListener annotationListener;
    private AnnotationCheckTreeNodeComparator comparator = new AnnotationCheckTreeNodeComparator();
    private AnnotationCheckLabelProvider lableProvider;
    private TreeViewer treeView;
    private Text documentSource;
    private ViewPart viewPart;
    private Text typeSystem;
    private HashMap<String, Image> images;
    private Text documentSink;
    private List<String> selectedTypes;
    private CheckDocument currentDocument = null;
    private String annotationMode;
    private AnnotationEditor casEditor;
    private List<CheckDocument> oldDocs;

    public AnnotationCheckComposite(Composite parent, int style, ViewPart viewPart) {
        super(parent, style);
        this.viewPart = viewPart;
        this.selectedTypes = new ArrayList<String>();
        this.initGui();
        this.annotationListener = new CheckAnnotationDocumentListener(this);
    }

    private void initGui() {
        this.setLayout((Layout)new FormLayout());
        this.setSize(400, 800);
        this.documentSource = new Text((Composite)this, 2052);
        FormData fdata1 = new FormData();
        fdata1.width = 200;
        fdata1.left = new FormAttachment(0, 1000, 5);
        fdata1.top = new FormAttachment(0, 1000, 5);
        fdata1.right = new FormAttachment(1000, 1000, -5);
        this.documentSource.setLayoutData((Object)fdata1);
        this.documentSource.setToolTipText("Document source folder...");
        this.documentSource.setMessage("Document source folder...");
        DropTarget dt = new DropTarget((Control)this.documentSource, 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    String fileString = fileList[0];
                    AnnotationCheckComposite.this.documentSource.setText(fileString);
                }
            }
        });
        this.documentSink = new Text((Composite)this, 2052);
        FormData fdatag = new FormData();
        fdatag.width = 200;
        fdatag.left = new FormAttachment(0, 1000, 5);
        fdatag.top = new FormAttachment(0, 1000, 30);
        fdatag.right = new FormAttachment(1000, 1000, -5);
        this.documentSink.setLayoutData((Object)fdatag);
        this.documentSink.setToolTipText("Document gold output folder...");
        this.documentSink.setMessage("Document gold output folder...");
        DropTarget dtg = new DropTarget((Control)this.documentSink, 18);
        dtg.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dtg.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    String fileString = fileList[0];
                    AnnotationCheckComposite.this.documentSink.setText(fileString);
                }
            }
        });
        this.typeSystem = new Text((Composite)this, 2052);
        FormData fdata2 = new FormData();
        fdata2.width = 200;
        fdata2.left = new FormAttachment(0, 1000, 5);
        fdata2.top = new FormAttachment(0, 1000, 55);
        fdata2.right = new FormAttachment(1000, 1000, -5);
        this.typeSystem.setLayoutData((Object)fdata2);
        this.typeSystem.setToolTipText("Type System...");
        this.typeSystem.setMessage("Type System...");
        DropTarget dt1 = new DropTarget((Control)this.typeSystem, 18);
        dt1.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt1.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    String fileString = fileList[0];
                    AnnotationCheckComposite.this.typeSystem.setText(fileString);
                }
            }
        });
        FormData fdata3 = new FormData();
        fdata3.left = new FormAttachment(0, 1000, 3);
        fdata3.top = new FormAttachment(0, 1000, 81);
        fdata3.right = new FormAttachment(1000, 1000, -3);
        fdata3.bottom = new FormAttachment(1000, 1000, -3);
        Composite comp = new Composite((Composite)this, 0x1000000);
        comp.setLayoutData((Object)fdata3);
        comp.setLayout((Layout)new FillLayout());
        this.treeView = new TreeViewer(comp, 770);
        AnnotationCheckContentProvider provider = new AnnotationCheckContentProvider();
        this.treeView.setContentProvider((IContentProvider)provider);
        this.treeView.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                char c = e.character;
                if (c == '1' || c == '2') {
                    if (c == '1') {
                        AnnotationCheckComposite.this.accept();
                    } else if (c == '2') {
                        AnnotationCheckComposite.this.reject();
                    }
                }
            }
        });
        this.lableProvider = new AnnotationCheckLabelProvider(this);
        this.treeView.setLabelProvider((IBaseLabelProvider)this.lableProvider);
        this.viewPart.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.treeView);
    }

    public void dispose() {
        super.dispose();
        this.viewPart.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        Collection<Image> values = this.images.values();
        for (Image image : values) {
            image.dispose();
        }
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    private void initImages() {
        this.images = new HashMap();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/accept.png");
        Image image = desc.createImage();
        String name = "accept";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/delete.png");
        image = desc.createImage();
        name = "delete";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/help.png");
        image = desc.createImage();
        name = "help";
        this.images.put(name, image);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreeSelection ts;
        if (part instanceof AnnotationCheckView && selection instanceof TreeSelection && (ts = (TreeSelection)selection).getFirstElement() instanceof AnnotationCheckTreeNode) {
            AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)ts.getFirstElement();
            CheckElement element = firstElement.getElement();
            int begin = 0;
            int end = 0;
            CheckDocument newDoc = null;
            if (element instanceof CheckAnnotation) {
                begin = ((CheckAnnotation)element).begin;
                end = ((CheckAnnotation)element).end;
                newDoc = (CheckDocument)firstElement.getParent().getElement();
            } else if (element instanceof CheckDocument) {
                newDoc = (CheckDocument)element;
            } else {
                return;
            }
            if (this.casEditor != null && this.casEditor.getDocumentProvider() != null && this.casEditor.getDocument() != null) {
                IFile file = ((FileEditorInput)this.casEditor.getEditorInput()).getFile();
                if (!newDoc.source.equals(file.getLocation().toOSString())) {
                    this.casEditor.getDocument().removeChangeListener((ICasDocumentListener)this.annotationListener);
                    this.casEditor = CheckAnnotationUtils.openInCasEditor(new File(newDoc.source), begin, end);
                    this.casEditor.getDocument().addChangeListener((ICasDocumentListener)this.annotationListener);
                } else {
                    this.casEditor.selectAndReveal(begin, end - begin);
                }
            } else {
                this.casEditor = CheckAnnotationUtils.openInCasEditor(new File(newDoc.source), begin, end);
                this.casEditor.getDocument().addChangeListener((ICasDocumentListener)this.annotationListener);
            }
            this.setAnnotationMode(this.annotationMode);
            Iterator typeIterator = this.casEditor.getDocument().getCAS().getTypeSystem().getTypeIterator();
            while (typeIterator.hasNext()) {
                Type type = (Type)typeIterator.next();
                boolean contains = this.selectedTypes.contains(type.getName());
                this.casEditor.setShownAnnotationType(type, contains);
            }
            this.currentDocument = newDoc;
            this.treeView.getControl().setFocus();
        }
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }

    public void restoreState(IMemento memento) {
        IMemento tsName;
        IMemento dir2;
        if (memento == null) {
            return;
        }
        IMemento dir = memento.getChild("documentSource");
        if (dir != null) {
            String id = dir.getID();
            this.documentSource.setText(id);
        }
        if ((dir2 = memento.getChild("documentSink")) != null) {
            String id = dir2.getID();
            this.documentSink.setText(id);
        }
        if ((tsName = memento.getChild("typeSystem")) != null) {
            String id = tsName.getID();
            this.typeSystem.setText(id);
        }
        for (IMemento eachMemento : memento.getChildren("selectedTypes")) {
            IMemento child = eachMemento.getChild("type");
            if (child == null) continue;
            this.selectedTypes.add(child.getID());
        }
    }

    public void saveState(IMemento memento) {
        memento.createChild("documentSource", this.documentSource.getText());
        memento.createChild("documentSink", this.documentSink.getText());
        memento.createChild("typeSystem", this.typeSystem.getText());
        for (String each : this.selectedTypes) {
            IMemento currentMemento = memento.createChild("selectedTypes", "type");
            currentMemento.createChild("type", each);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeView;
    }

    public String getDocumentSource() {
        return this.documentSource.getText();
    }

    public String getDocumentSink() {
        return this.documentSink.getText();
    }

    public String getTypeSystem() {
        return this.typeSystem.getText();
    }

    public List<String> getSelectedTypes() {
        return this.selectedTypes;
    }

    public void setSelectedTypes(List<String> selection) {
        this.selectedTypes = selection;
    }

    public void reject() {
        TreeSelection selection = (TreeSelection)this.treeView.getSelection();
        AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)selection.getFirstElement();
        if (firstElement == null) {
            return;
        }
        firstElement.getElement().checked = true;
        firstElement.getElement().keep = false;
        this.moveToNext();
        this.treeView.refresh();
    }

    public void accept() {
        TreeSelection selection = (TreeSelection)this.treeView.getSelection();
        AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)selection.getFirstElement();
        if (firstElement == null) {
            return;
        }
        firstElement.getElement().checked = true;
        firstElement.getElement().keep = true;
        this.moveToNext();
        this.treeView.refresh();
    }

    public void moveToNext() {
        TreeSelection selection = (TreeSelection)this.treeView.getSelection();
        AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)selection.getFirstElement();
        if (firstElement == null) {
            return;
        }
        IAnnotationCheckTreeNode parent = firstElement.getParent();
        AnnotationCheckTreeNode[] children = parent.getChildren();
        List<AnnotationCheckTreeNode> list = Arrays.asList(children);
        int indexOf = list.indexOf(firstElement);
        IAnnotationCheckTreeNode brother = null;
        IAnnotationCheckTreeNode uncle = parent;
        if (list != null && !list.isEmpty()) {
            if (indexOf == -1) {
                brother = list.get(0);
            } else if (firstElement.getElement() instanceof CheckDocument && indexOf < list.size() - 1) {
                uncle = list.get(indexOf + 1);
                if (uncle.getChildren().length > 0) {
                    brother = uncle.getChildren()[0];
                }
            } else if (indexOf < list.size() - 1) {
                brother = list.get(indexOf + 1);
            } else if (firstElement.getElement() instanceof CheckAnnotation) {
                brother = null;
                AnnotationCheckTreeNode[] children2 = parent.getParent().getChildren();
                List<AnnotationCheckTreeNode> list2 = Arrays.asList(children2);
                int indexOf2 = list2.indexOf(parent);
                if (list2 != null && !list2.isEmpty()) {
                    if (indexOf2 == -1) {
                        uncle = list2.get(0);
                    } else if (indexOf2 < list2.size() - 1 && (uncle = (IAnnotationCheckTreeNode)list2.get(indexOf2 + 1)).getChildren().length != 0) {
                        brother = uncle.getChildren()[0];
                    }
                }
            }
        }
        TreePath treePath = null;
        treePath = brother == null ? new TreePath(new Object[]{this.treeView.getInput(), uncle}) : new TreePath(new Object[]{this.treeView.getInput(), uncle, brother});
        TreeSelection newSelection = new TreeSelection(treePath);
        this.treeView.setSelection((ISelection)newSelection, true);
        if (firstElement.getElement() instanceof CheckAnnotation) {
            boolean allChecked = true;
            boolean oneKeep = false;
            for (AnnotationCheckTreeNode each : list) {
                CheckElement element = each.getElement();
                allChecked &= element.checked;
                oneKeep |= element.keep;
            }
            parent.getElement().checked = allChecked;
            parent.getElement().keep = oneKeep;
        }
    }

    public void save() {
        AnnotationCheckTreeNode root = (AnnotationCheckTreeNode)this.treeView.getInput();
        AnnotationCheckTreeNode[] children = root.getChildren();
        ArrayList<CheckDocument> docs = new ArrayList<CheckDocument>(this.oldDocs);
        TypeSystemDescription tsd = null;
        try {
            tsd = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(this.typeSystem.getText()));
            tsd.resolveImports();
        }
        catch (InvalidXMLException e) {
            RutaAddonsPlugin.error(e);
        }
        catch (IOException e) {
            RutaAddonsPlugin.error(e);
        }
        CAS cas = null;
        try {
            cas = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, (FsIndexDescription[])new FsIndexDescription[0]);
        }
        catch (ResourceInitializationException e) {
            RutaAddonsPlugin.error(e);
        }
        for (AnnotationCheckTreeNode each : children) {
            CheckDocument cd = (CheckDocument)each.getElement();
            if (cd.checked && cd.keep) {
                AnnotationCheckTreeNode[] annotationNodes;
                cas.reset();
                File oldFile = new File(cd.source);
                File goldFile = new File(this.documentSink.getText(), oldFile.getName());
                if (goldFile.exists()) {
                    try {
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(goldFile), (CAS)cas, (boolean)false);
                    }
                    catch (FileNotFoundException e) {
                        RutaAddonsPlugin.error(e);
                    }
                    catch (SAXException e) {
                        RutaAddonsPlugin.error(e);
                    }
                    catch (IOException e) {
                        RutaAddonsPlugin.error(e);
                    }
                } else {
                    try {
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(oldFile), (CAS)cas, (boolean)true);
                    }
                    catch (FileNotFoundException e) {
                        RutaAddonsPlugin.error(e);
                    }
                    catch (SAXException e) {
                        RutaAddonsPlugin.error(e);
                    }
                    catch (IOException e) {
                        RutaAddonsPlugin.error(e);
                    }
                    String documentText = cas.getDocumentText();
                    cas.reset();
                    cas.setDocumentText(documentText);
                }
                for (AnnotationCheckTreeNode eachAN : annotationNodes = each.getChildren()) {
                    Type type;
                    CheckAnnotation ca = (CheckAnnotation)eachAN.getElement();
                    if (!ca.checked || !ca.keep || (type = cas.getTypeSystem().getType(ca.type)) == null) continue;
                    AnnotationFS createAnnotation = cas.createAnnotation(type, ca.begin, ca.end);
                    cas.addFsToIndexes((FeatureStructure)createAnnotation);
                }
                try {
                    CheckAnnotationUtils.writeXmi(cas, goldFile);
                }
                catch (Exception e) {
                    RutaAddonsPlugin.error(e);
                }
                cd.checkedTypes.addAll(this.selectedTypes);
                if (!docs.contains(cd)) {
                    docs.add(cd);
                }
            }
            File dataFile = new File(this.documentSink.getText(), "data.xml");
            try {
                XMLUtils.write(docs, dataFile);
            }
            catch (IOException e) {
                RutaAddonsPlugin.error(e);
            }
        }
    }

    public void setAnnotationMode(String typeString) {
        this.annotationMode = typeString;
        if (this.casEditor != null && this.casEditor.getDocument() != null && typeString != null) {
            Type type = this.casEditor.getDocument().getCAS().getTypeSystem().getType(typeString);
            this.casEditor.setAnnotationMode(type);
        }
    }

    public void addedAnnotation(Collection<AnnotationFS> annotations) {
        AnnotationCheckTreeNode[] children;
        AnnotationCheckRootNode root = (AnnotationCheckRootNode)this.treeView.getInput();
        for (AnnotationCheckTreeNode docNode : children = root.getChildren()) {
            if (!docNode.getElement().equals(this.currentDocument)) continue;
            ArrayList<AnnotationCheckTreeNode> annotationList = new ArrayList<AnnotationCheckTreeNode>(Arrays.asList(docNode.getChildren()));
            for (AnnotationFS eachAnnotation : annotations) {
                CheckAnnotation ac = new CheckAnnotation(eachAnnotation);
                ac.checked = true;
                ac.keep = true;
                AnnotationCheckTreeNode anode = new AnnotationCheckTreeNode(docNode, ac);
                annotationList.add(anode);
            }
            Collections.sort(annotationList, this.comparator);
            docNode.setChildren(annotationList);
            this.treeView.refresh((Object)docNode);
            break;
        }
    }

    public void removedAnnotation(Collection<AnnotationFS> annotations) {
        AnnotationCheckTreeNode[] children;
        AnnotationCheckRootNode root = (AnnotationCheckRootNode)this.treeView.getInput();
        for (AnnotationCheckTreeNode docNode : children = root.getChildren()) {
            AnnotationCheckTreeNode[] achildren;
            if (!docNode.getElement().equals(this.currentDocument)) continue;
            for (AnnotationCheckTreeNode anode : achildren = docNode.getChildren()) {
                CheckAnnotation e = (CheckAnnotation)anode.getElement();
                for (AnnotationFS eachAnnotation : annotations) {
                    if (eachAnnotation.getBegin() != e.begin || eachAnnotation.getEnd() != e.end || !eachAnnotation.getType().getName().equals(e.type)) continue;
                    e.checked = true;
                    e.keep = false;
                }
            }
            this.treeView.refresh((Object)docNode);
            break;
        }
    }

    public void updatedAnnotation(Collection<AnnotationFS> annotations) {
    }

    public void setOldDocs(List<CheckDocument> docs) {
        this.oldDocs = docs;
    }
}

