/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.cde.IRutaRuleConstraint;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class RutaRuleListConstraint
implements IRutaRuleConstraint {
    private String rules;
    private String description;
    private String typeSystemLocation;
    private AnalysisEngine ae;
    private boolean initalized = false;

    public RutaRuleListConstraint(String rules, String description) {
        this.rules = rules;
        this.description = description;
        this.typeSystemLocation = "";
    }

    public void initialize() throws Exception {
        String script = "PACKAGE org.apache.uima.ruta;\n\n";
        if (!this.rules.endsWith(";")) {
            this.rules = this.rules + ";";
        }
        script = script + this.rules;
        URL aedesc = RutaEngine.class.getResource("BasicEngine.xml");
        XMLInputSource inae = new XMLInputSource(aedesc);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(inae);
        ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
        AnalysisEngineDescription aed = (AnalysisEngineDescription)specifier;
        TypeSystemDescription basicTypeSystem = aed.getAnalysisEngineMetaData().getTypeSystem();
        if (!this.typeSystemLocation.equals("")) {
            String tsLocation = this.typeSystemLocation;
            ArrayList<TypeSystemDescription> tsds = new ArrayList<TypeSystemDescription>();
            tsds.add(basicTypeSystem);
            if (this.typeSystemLocation.endsWith(".ruta")) {
                IFile iFile = RutaAddonsPlugin.getIFile(this.typeSystemLocation);
                IPath scriptPath = iFile.getLocation();
                IProject project = iFile.getProject();
                IPath descriptorRootPath = RutaProjectUtils.getDescriptorRootPath((IProject)project);
                resMgr.setDataPath(descriptorRootPath.toPortableString());
                IPath path = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)scriptPath, (IProject)project);
                tsLocation = path.toPortableString();
            }
            File tsFile = new File(tsLocation);
            XMLInputSource ints = new XMLInputSource(tsFile);
            TypeSystemDescription importTSD = UIMAFramework.getXMLParser().parseTypeSystemDescription(ints);
            importTSD.resolveImports(resMgr);
            tsds.add(importTSD);
            TypeSystemDescription mergeTypeSystems = CasCreationUtils.mergeTypeSystems(tsds);
            aed.getAnalysisEngineMetaData().setTypeSystem(mergeTypeSystems);
        }
        aed.resolveImports(resMgr);
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aed, (ResourceManager)resMgr, null);
        File tempFile = File.createTempFile("RutaCDE", ".ruta");
        tempFile.deleteOnExit();
        FileUtils.saveString2File((String)script, (File)tempFile, (String)"UTF-8");
        String portableString = Path.fromOSString((String)tempFile.getParentFile().getPath()).toPortableString();
        this.ae.setConfigParameterValue("scriptPaths", (Object)new String[]{portableString});
        String name = tempFile.getName().substring(0, tempFile.getName().length() - 5);
        this.ae.setConfigParameterValue("mainScript", (Object)name);
        this.ae.setConfigParameterValue("debug", (Object)true);
        this.ae.setConfigParameterValue("debugWithMatches", (Object)true);
        this.ae.setConfigParameterValue("profile", (Object)false);
        this.ae.setConfigParameterValue("statistics", (Object)false);
        this.ae.reconfigure();
    }

    public Double processConstraint(CAS cas) throws Exception {
        if (!this.initalized) {
            this.initialize();
        }
        Type matchedType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugMatchedRuleMatch");
        Type ruleApplyType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugRuleApply");
        Type blockApplyType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugBlockApply");
        this.removeDebugAnnotations(cas, matchedType, ruleApplyType, blockApplyType);
        double applyAmount = 0.0;
        double triedAmount = 0.0;
        this.ae.process(cas);
        Feature innerApplyFeature = blockApplyType.getFeatureByBaseName("innerApply");
        Feature appliedFeature = blockApplyType.getFeatureByBaseName("applied");
        Feature triedFeature = blockApplyType.getFeatureByBaseName("tried");
        FSIterator iterator = cas.getAnnotationIndex(blockApplyType).iterator();
        while (iterator.isValid()) {
            AnnotationFS fs = (AnnotationFS)iterator.get();
            if (fs.getType().equals(blockApplyType)) {
                FeatureStructure featureValue = fs.getFeatureValue(innerApplyFeature);
                FSArray array = (FSArray)featureValue;
                for (int i = 0; i < array.size(); ++i) {
                    AnnotationFS ruleApply = (AnnotationFS)array.get(i);
                    if (!ruleApply.getType().equals(ruleApplyType)) continue;
                    applyAmount += (double)ruleApply.getIntValue(appliedFeature);
                    triedAmount += (double)ruleApply.getIntValue(triedFeature);
                }
            }
            iterator.moveToNext();
        }
        this.removeDebugAnnotations(cas, matchedType, ruleApplyType, blockApplyType);
        this.ae.destroy();
        if (triedAmount == 0.0) {
            return null;
        }
        return applyAmount / triedAmount;
    }

    private void removeDebugAnnotations(CAS cas, Type matchedType, Type ruleApplyType, Type blockApplyType) {
        ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
        AnnotationIndex annotationIndex = cas.getAnnotationIndex(blockApplyType);
        for (AnnotationFS annotationFS : annotationIndex) {
            toRemove.add(annotationFS);
        }
        annotationIndex = cas.getAnnotationIndex(ruleApplyType);
        for (AnnotationFS annotationFS : annotationIndex) {
            toRemove.add(annotationFS);
        }
        annotationIndex = cas.getAnnotationIndex(matchedType);
        for (AnnotationFS annotationFS : annotationIndex) {
            toRemove.add(annotationFS);
        }
        for (AnnotationFS annotationFS : toRemove) {
            cas.removeFsFromIndexes((FeatureStructure)annotationFS);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTypeSystemLocation(String location) {
        this.typeSystemLocation = location;
    }

    public String getTypeSystemLocation() {
        return this.typeSystemLocation;
    }

    public String getData() {
        return this.rules;
    }

    public void setData(String data) {
        this.rules = data;
    }
}

