/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationFailure;
import org.apache.openejb.config.ValidationResults;
import org.apache.openejb.config.ValidationWarning;

public class ValidationFailedException
extends OpenEJBException
implements ValidationResults {
    private final ValidationError[] errors;
    private final ValidationFailure[] failures;
    private final ValidationWarning[] warnings;
    private final String name;
    private final String moduleType;

    public ValidationFailedException(String message, ValidationResults set) {
        this(message, set, null);
    }

    public ValidationFailedException(String message, ValidationResults set, ValidationFailedException e) {
        super(message, e);
        this.name = set.getName();
        this.errors = set.getErrors();
        this.failures = set.getFailures();
        this.warnings = set.getWarnings();
        this.moduleType = set.getModuleType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValidationError[] getErrors() {
        return this.errors;
    }

    @Override
    public ValidationFailure[] getFailures() {
        return this.failures;
    }

    @Override
    public ValidationWarning[] getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean hasWarnings() {
        return this.warnings.length > 0;
    }

    @Override
    public boolean hasFailures() {
        return this.failures.length > 0;
    }

    @Override
    public boolean hasErrors() {
        return this.errors.length > 0;
    }

    @Override
    public String getModuleType() {
        return this.moduleType;
    }
}

