/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tomee.loader.filter.Filter;

public class FilterList
implements Filter {
    private final List<Filter> filters = new ArrayList<Filter>();

    public FilterList(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public FilterList(Iterable<Filter> filters) {
        for (Filter filter : filters) {
            this.filters.add(filter);
        }
    }

    @Override
    public boolean accept(String name) {
        for (Filter filter : this.filters) {
            if (!filter.accept(name)) continue;
            return true;
        }
        return false;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public String toString() {
        return "FilterList{filters=" + String.valueOf(this.filters) + "}";
    }
}

