/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ValueEncoderFactory;

public class TypeCoercedValueEncoderFactory
implements ValueEncoderFactory<Object> {
    private final TypeCoercer typeCoercer;

    public TypeCoercedValueEncoderFactory(TypeCoercer typeCoercer) {
        this.typeCoercer = typeCoercer;
    }

    @Override
    public ValueEncoder<Object> create(final Class<Object> type) {
        final boolean blankToNull = Boolean.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type);
        return new ValueEncoder<Object>(){

            @Override
            public String toClient(Object value) {
                return (String)TypeCoercedValueEncoderFactory.this.typeCoercer.coerce(value, String.class);
            }

            @Override
            public Object toValue(String clientValue) {
                if (blankToNull && InternalUtils.isBlank((String)clientValue)) {
                    return null;
                }
                return TypeCoercedValueEncoderFactory.this.typeCoercer.coerce((Object)clientValue, type);
            }
        };
    }
}

