/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.apache.storm.trident.spout.ISpoutPartition;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.RotatingTransactionalState;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedTridentSpoutExecutor
implements ITridentSpout<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedTridentSpoutExecutor.class);
    IPartitionedTridentSpout<Object, ISpoutPartition, Object> spout;

    public PartitionedTridentSpoutExecutor(IPartitionedTridentSpout<Object, ISpoutPartition, Object> spout) {
        this.spout = spout;
    }

    public IPartitionedTridentSpout<Object, ISpoutPartition, Object> getPartitionedSpout() {
        return this.spout;
    }

    @Override
    public ITridentSpout.BatchCoordinator<Object> getCoordinator(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Coordinator(conf, context);
    }

    @Override
    public ITridentSpout.Emitter<Object> getEmitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Emitter(txStateId, conf, context);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.spout.getComponentConfiguration();
    }

    @Override
    public Fields getOutputFields() {
        return this.spout.getOutputFields();
    }

    class Coordinator
    implements ITridentSpout.BatchCoordinator<Object> {
        private IPartitionedTridentSpout.Coordinator<Object> coordinator;

        Coordinator(Map<String, Object> conf, TopologyContext context) {
            this.coordinator = PartitionedTridentSpoutExecutor.this.spout.getCoordinator(conf, context);
        }

        @Override
        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            LOG.debug("Initialize Transaction. txid = {}, prevMetadata = {}, currMetadata = {}", new Object[]{txid, prevMetadata, currMetadata});
            if (currMetadata != null) {
                return currMetadata;
            }
            return this.coordinator.getPartitionsForBatch();
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this.coordinator.close();
            LOG.debug("Closed");
        }

        @Override
        public void success(long txid) {
            LOG.debug("Success transaction id " + txid);
        }

        @Override
        public boolean isReady(long txid) {
            boolean ready = this.coordinator.isReady(txid);
            LOG.debug("isReady = {} ", (Object)ready);
            return ready;
        }
    }

    class Emitter
    implements ITridentSpout.Emitter<Object> {
        Object savedCoordinatorMeta = null;
        private IPartitionedTridentSpout.Emitter<Object, ISpoutPartition, Object> emitter;
        private TransactionalState state;
        private Map<String, EmitterPartitionState> partitionStates = new HashMap<String, EmitterPartitionState>();
        private int index;
        private int numTasks;

        Emitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
            this.emitter = PartitionedTridentSpoutExecutor.this.spout.getEmitter(conf, context);
            this.state = TransactionalState.newUserState(conf, txStateId);
            this.index = context.getThisTaskIndex();
            this.numTasks = context.getComponentTasks(context.getThisComponentId()).size();
        }

        @Override
        public void emitBatch(TransactionAttempt tx, Object coordinatorMeta, TridentCollector collector) {
            boolean bl;
            LOG.debug("Emitting Batch. [transaction = {}], [coordinatorMeta = {}], [collector = {}]", new Object[]{tx, coordinatorMeta, collector});
            if (this.savedCoordinatorMeta == null || !this.savedCoordinatorMeta.equals(coordinatorMeta)) {
                this.partitionStates.clear();
                List<ISpoutPartition> taskPartitions = this.emitter.getPartitionsForTask(this.index, this.numTasks, this.emitter.getOrderedPartitions(coordinatorMeta));
                for (ISpoutPartition iSpoutPartition : taskPartitions) {
                    this.partitionStates.put(iSpoutPartition.getId(), new EmitterPartitionState(new RotatingTransactionalState(this.state, iSpoutPartition.getId()), iSpoutPartition));
                }
                this.emitter.refreshPartitions(taskPartitions);
                this.savedCoordinatorMeta = coordinatorMeta;
            }
            HashMap<ISpoutPartition, Object> prevStateMap = new HashMap<ISpoutPartition, Object>();
            HashSet<ISpoutPartition> partitions = new HashSet<ISpoutPartition>();
            for (EmitterPartitionState emitterPartitionState : this.partitionStates.values()) {
                prevStateMap.put(emitterPartitionState.partition, emitterPartitionState.rotatingState.getPreviousState(tx.getTransactionId()));
                partitions.add(emitterPartitionState.partition);
            }
            boolean bl2 = true;
            for (EmitterPartitionState emitterPartitionState : this.partitionStates.values()) {
                if (emitterPartitionState.rotatingState.getState(tx.getTransactionId()) == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                Map<ISpoutPartition, Object> map = this.emitter.emitBatchNew(tx, collector, partitions, prevStateMap);
                for (Map.Entry<ISpoutPartition, Object> entry : map.entrySet()) {
                    ISpoutPartition partition = entry.getKey();
                    final Object batchMeta = entry.getValue();
                    this.partitionStates.get((Object)partition.getId()).rotatingState.getStateOrCreate(tx.getTransactionId(), new RotatingTransactionalState.StateInitializer(){

                        @Override
                        public Object init(long txid, Object lastState) {
                            return batchMeta;
                        }
                    });
                }
            } else {
                for (Map.Entry<String, EmitterPartitionState> entry : this.partitionStates.entrySet()) {
                    EmitterPartitionState emitterPartitionState = entry.getValue();
                    Object partitionBatchMeta = emitterPartitionState.rotatingState.getState(tx.getTransactionId());
                    this.emitter.reEmitPartitionBatch(tx, collector, emitterPartitionState.partition, partitionBatchMeta);
                }
            }
            LOG.debug("Emitted Batch. [tx = {}], [coordinatorMeta = {}], [collector = {}]", new Object[]{tx, coordinatorMeta, collector});
        }

        @Override
        public void success(TransactionAttempt tx) {
            LOG.debug("Success transaction " + String.valueOf(tx));
            for (EmitterPartitionState state : this.partitionStates.values()) {
                state.rotatingState.cleanupBefore(tx.getTransactionId());
            }
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this.state.close();
            this.emitter.close();
            LOG.debug("Closed");
        }
    }

    static class EmitterPartitionState {
        public RotatingTransactionalState rotatingState;
        public ISpoutPartition partition;

        EmitterPartitionState(RotatingTransactionalState s, ISpoutPartition p) {
            this.rotatingState = s;
            this.partition = p;
        }
    }
}

