/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.operation.impl.GroupCollector;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class GroupedAggregator
implements Aggregator<Object[]> {
    TridentTupleView.ProjectionFactory groupFactory;
    TridentTupleView.ProjectionFactory inputFactory;
    Aggregator agg;
    ComboList.Factory fact;
    Fields inFields;
    Fields groupFields;

    public GroupedAggregator(Aggregator agg, Fields group, Fields input, int outSize) {
        this.groupFields = group;
        this.inFields = input;
        this.agg = agg;
        int[] sizes = new int[]{this.groupFields.size(), outSize};
        this.fact = new ComboList.Factory(sizes);
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this.inputFactory = context.makeProjectionFactory(this.inFields);
        this.groupFactory = context.makeProjectionFactory(this.groupFields);
        this.agg.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this.inputFactory));
    }

    @Override
    public Object[] init(Object batchId, TridentCollector collector) {
        return new Object[]{new GroupCollector(collector, this.fact), new HashMap(), batchId};
    }

    @Override
    public void aggregate(Object[] arr, TridentTuple tuple, TridentCollector collector) {
        Object curr;
        GroupCollector groupColl = (GroupCollector)arr[0];
        Map val = (Map)arr[1];
        TridentTuple group = this.groupFactory.create((TridentTupleView)tuple);
        TridentTuple input = this.inputFactory.create((TridentTupleView)tuple);
        if (!val.containsKey(group)) {
            curr = this.agg.init(arr[2], groupColl);
            val.put(group, curr);
        } else {
            curr = val.get(group);
        }
        groupColl.currGroup = group;
        this.agg.aggregate(curr, input, groupColl);
    }

    @Override
    public void complete(Object[] arr, TridentCollector collector) {
        Map val = (Map)arr[1];
        GroupCollector groupColl = (GroupCollector)arr[0];
        for (Map.Entry e : val.entrySet()) {
            groupColl.currGroup = (List)e.getKey();
            this.agg.complete(e.getValue(), groupColl);
        }
    }

    @Override
    public void cleanup() {
        this.agg.cleanup();
    }
}

