/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.docker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.container.docker.DockerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRunCommand
extends DockerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DockerRunCommand.class);
    private static final String RUN_COMMAND = "run";
    private final String image;
    private List<String> overrideCommandWithArgs;

    public DockerRunCommand(String containerName, String userInfo, String image) {
        super(RUN_COMMAND);
        super.addCommandArguments("--name=" + containerName, "--user=" + userInfo);
        this.image = image;
    }

    public DockerRunCommand removeContainerOnExit() {
        super.addCommandArguments("--rm");
        return this;
    }

    public DockerRunCommand detachOnRun() {
        super.addCommandArguments("-d");
        return this;
    }

    public DockerRunCommand setContainerWorkDir(String workdir) {
        super.addCommandArguments("--workdir=" + workdir);
        return this;
    }

    public DockerRunCommand setNetworkType(String type) {
        super.addCommandArguments("--net=" + type);
        return this;
    }

    public DockerRunCommand addReadWriteMountLocation(String sourcePath, String destinationPath, boolean createSource) throws IOException {
        boolean sourceExists;
        if (!createSource && !(sourceExists = new File(sourcePath).exists())) {
            throw new IOException("SourcePath " + sourcePath + " doesn't exit.");
        }
        super.addCommandArguments("-v", sourcePath + ":" + destinationPath);
        return this;
    }

    public DockerRunCommand addReadWriteMountLocation(String sourcePath, String destinationPath) throws IOException {
        return this.addReadWriteMountLocation(sourcePath, destinationPath, true);
    }

    public DockerRunCommand addAllReadWriteMountLocations(List<String> paths) throws IOException {
        return this.addAllReadWriteMountLocations(paths, true);
    }

    public DockerRunCommand addAllReadWriteMountLocations(List<String> paths, boolean createSource) throws IOException {
        for (String dir : paths) {
            this.addReadWriteMountLocation(dir, dir, createSource);
        }
        return this;
    }

    public DockerRunCommand addReadOnlyMountLocation(String sourcePath, String destinationPath, boolean createSource) throws IOException {
        boolean sourceExists;
        if (!createSource && !(sourceExists = new File(sourcePath).exists())) {
            throw new IOException("SourcePath " + sourcePath + " doesn't exit.");
        }
        super.addCommandArguments("-v", sourcePath + ":" + destinationPath + ":ro");
        return this;
    }

    public DockerRunCommand addReadOnlyMountLocation(String sourcePath, String destinationPath) throws IOException {
        return this.addReadOnlyMountLocation(sourcePath, destinationPath, true);
    }

    public DockerRunCommand addAllReadOnlyMountLocations(List<String> paths) throws IOException {
        return this.addAllReadOnlyMountLocations(paths, true);
    }

    public DockerRunCommand addAllReadOnlyMountLocations(List<String> paths, boolean createSource) throws IOException {
        for (String dir : paths) {
            this.addReadOnlyMountLocation(dir, dir, createSource);
        }
        return this;
    }

    public DockerRunCommand addCpuSetBindings(List<String> cores, String memoryNode) {
        if (!cores.isEmpty()) {
            super.addCommandArguments("--cpuset-cpus=" + StringUtils.join(cores, (String)","));
        }
        if (memoryNode != null) {
            super.addCommandArguments("--cpuset-mems=" + memoryNode);
        }
        return this;
    }

    public DockerRunCommand setCGroupParent(String parentPath) {
        super.addCommandArguments("--cgroup-parent=" + parentPath);
        return this;
    }

    public DockerRunCommand setPrivileged() {
        super.addCommandArguments("--privileged");
        return this;
    }

    public DockerRunCommand setCapabilities(Set<String> capabilities) {
        super.addCommandArguments("--cap-drop=ALL");
        for (String capability : capabilities) {
            super.addCommandArguments("--cap-add=" + capability);
        }
        return this;
    }

    public DockerRunCommand addDevice(String sourceDevice, String destinationDevice) {
        super.addCommandArguments("--device=" + sourceDevice + ":" + destinationDevice);
        return this;
    }

    public DockerRunCommand enableDetach() {
        super.addCommandArguments("--detach=true");
        return this;
    }

    public DockerRunCommand disableDetach() {
        super.addCommandArguments("--detach=false");
        return this;
    }

    public DockerRunCommand groupAdd(String[] groups) {
        for (int i = 0; i < groups.length; ++i) {
            super.addCommandArguments("--group-add " + groups[i]);
        }
        return this;
    }

    public DockerRunCommand setOverrideCommandWithArgs(List<String> overrideCommandWithArgs) {
        this.overrideCommandWithArgs = overrideCommandWithArgs;
        return this;
    }

    public DockerRunCommand setReadonly() {
        super.addCommandArguments("--read-only");
        return this;
    }

    public DockerRunCommand setSeccompProfile(String jsonPath) {
        super.addCommandArguments("--security-opt seccomp=" + jsonPath);
        return this;
    }

    public DockerRunCommand setNoNewPrivileges() {
        super.addCommandArguments("--security-opt no-new-privileges");
        return this;
    }

    public DockerRunCommand setCpuShares(int cpuShares) {
        if (cpuShares > 0 && cpuShares < 2) {
            cpuShares = 2;
        }
        super.addCommandArguments("--cpu-shares=" + String.valueOf(cpuShares));
        return this;
    }

    public DockerRunCommand setCpus(double cpus) {
        super.addCommandArguments("--cpus=" + cpus);
        return this;
    }

    public DockerRunCommand setMemoryMb(int memoryMb) {
        super.addCommandArguments("--memory=" + memoryMb + "m");
        return this;
    }

    public DockerRunCommand setCidFile(String cidFile) {
        super.addCommandArguments("--cidfile=" + cidFile);
        return this;
    }

    @Override
    public String getCommandWithArguments() {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(super.getCommandWithArguments());
        argList.add(this.image);
        if (this.overrideCommandWithArgs != null) {
            argList.addAll(this.overrideCommandWithArgs);
        }
        return StringUtils.join(argList, (String)" ");
    }
}

