/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.codahale.metrics.health.HealthCheckRegistry;
import io.dropwizard.health.HealthStateAggregator;
import io.dropwizard.health.HealthStateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthEnvironment.class);
    private final @NonNull HealthCheckRegistry healthCheckRegistry;
    private final @NonNull Collection<HealthStateListener> healthStateListeners;
    private @Nullable HealthStateAggregator healthStateAggregator;

    public HealthEnvironment(HealthCheckRegistry healthCheckRegistry) {
        this.healthCheckRegistry = Objects.requireNonNull(healthCheckRegistry);
        this.healthStateListeners = new ArrayList<HealthStateListener>();
    }

    public void addHealthStateListener(HealthStateListener listener) {
        this.healthStateListeners.add(listener);
    }

    public @NonNull HealthCheckRegistry healthChecks() {
        return this.healthCheckRegistry;
    }

    public @NonNull Collection<HealthStateListener> healthStateListeners() {
        return this.healthStateListeners;
    }

    public @NonNull HealthStateAggregator healthStateAggregator() {
        if (this.healthStateAggregator == null) {
            String message = "Cannot access the HealthStateAggregator before HealthFactory setup has occurred";
            LOGGER.error("Cannot access the HealthStateAggregator before HealthFactory setup has occurred");
            throw new IllegalStateException("Cannot access the HealthStateAggregator before HealthFactory setup has occurred");
        }
        return this.healthStateAggregator;
    }

    void setHealthStateAggregator(@NonNull HealthStateAggregator healthStateAggregator) {
        this.healthStateAggregator = Objects.requireNonNull(healthStateAggregator);
    }
}

