/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.graph;

import java.io.Serializable;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.UndirectedGraph;
import org.apache.storm.shade.org.jgrapht.graph.GraphDelegator;
import org.apache.storm.shade.org.jgrapht.util.ArrayUnenforcedSet;

public class AsUndirectedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
UndirectedGraph<V, E> {
    private static final long serialVersionUID = 3257845485078065462L;
    private static final String NO_EDGE_ADD = "this graph does not support edge addition";
    private static final String UNDIRECTED = "this graph only supports undirected operations";

    public AsUndirectedGraph(DirectedGraph<V, E> g) {
        super(g);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        Set forwardList = super.getAllEdges(sourceVertex, targetVertex);
        if (sourceVertex.equals(targetVertex)) {
            return forwardList;
        }
        Set reverseList = super.getAllEdges(targetVertex, sourceVertex);
        ArrayUnenforcedSet list = new ArrayUnenforcedSet(forwardList.size() + reverseList.size());
        list.addAll(forwardList);
        list.addAll(reverseList);
        return list;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        Object edge = super.getEdge(sourceVertex, targetVertex);
        if (edge != null) {
            return edge;
        }
        return super.getEdge(targetVertex, sourceVertex);
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(NO_EDGE_ADD);
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        throw new UnsupportedOperationException(NO_EDGE_ADD);
    }

    @Override
    public int degreeOf(V vertex) {
        return super.inDegreeOf(vertex) + super.outDegreeOf(vertex);
    }

    @Override
    public int inDegreeOf(V vertex) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public int outDegreeOf(V vertex) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public String toString() {
        return super.toStringFromSets(this.vertexSet(), this.edgeSet(), false);
    }
}

