/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.storm.shade.org.apache.commons.collections4.Predicate;
import org.apache.storm.shade.org.apache.commons.collections4.Transformer;
import org.apache.storm.shade.org.apache.commons.collections4.functors.ConstantTransformer;
import org.apache.storm.shade.org.apache.commons.collections4.functors.FunctorUtils;

public class SwitchTransformer<T, R>
implements Transformer<T, R>,
Serializable {
    private static final long serialVersionUID = -6404460890903469332L;
    private final Predicate<? super T>[] iPredicates;
    private final Transformer<? super T, ? extends R>[] iTransformers;
    private final Transformer<? super T, ? extends R> iDefault;

    public static <I, O> Transformer<I, O> switchTransformer(Map<? extends Predicate<? super I>, ? extends Transformer<? super I, ? extends O>> map) {
        Objects.requireNonNull(map, "map");
        if (map.isEmpty()) {
            return ConstantTransformer.nullTransformer();
        }
        Transformer<? super I, ? extends O> defaultTransformer = map.remove(null);
        int size = map.size();
        if (size == 0) {
            return defaultTransformer == null ? ConstantTransformer.nullTransformer() : defaultTransformer;
        }
        Transformer[] transformers = new Transformer[size];
        Predicate[] preds = new Predicate[size];
        int i = 0;
        for (Map.Entry<Predicate<I>, Transformer<I, O>> entry : map.entrySet()) {
            preds[i] = entry.getKey();
            transformers[i] = entry.getValue();
            ++i;
        }
        return new SwitchTransformer<I, O>(false, preds, transformers, defaultTransformer);
    }

    public static <I, O> Transformer<I, O> switchTransformer(Predicate<? super I>[] predicates, Transformer<? super I, ? extends O>[] transformers, Transformer<? super I, ? extends O> defaultTransformer) {
        FunctorUtils.validate(predicates);
        FunctorUtils.validate(transformers);
        if (predicates.length != transformers.length) {
            throw new IllegalArgumentException("The predicate and transformer arrays must be the same size");
        }
        if (predicates.length == 0) {
            return defaultTransformer == null ? ConstantTransformer.nullTransformer() : defaultTransformer;
        }
        return new SwitchTransformer<I, O>(predicates, transformers, defaultTransformer);
    }

    private SwitchTransformer(boolean clone, Predicate<? super T>[] predicates, Transformer<? super T, ? extends R>[] transformers, Transformer<? super T, ? extends R> defaultTransformer) {
        this.iPredicates = clone ? (Predicate[])FunctorUtils.copy((java.util.function.Predicate[])predicates) : predicates;
        this.iTransformers = clone ? (Transformer[])FunctorUtils.copy((Function[])transformers) : transformers;
        this.iDefault = defaultTransformer == null ? ConstantTransformer.nullTransformer() : defaultTransformer;
    }

    public SwitchTransformer(Predicate<? super T>[] predicates, Transformer<? super T, ? extends R>[] transformers, Transformer<? super T, ? extends R> defaultTransformer) {
        this(true, predicates, transformers, defaultTransformer);
    }

    public Transformer<? super T, ? extends R> getDefaultTransformer() {
        return this.iDefault;
    }

    public Predicate<? super T>[] getPredicates() {
        return (Predicate[])FunctorUtils.copy((java.util.function.Predicate[])this.iPredicates);
    }

    public Transformer<? super T, ? extends R>[] getTransformers() {
        return (Transformer[])FunctorUtils.copy((Function[])this.iTransformers);
    }

    @Override
    public R transform(T input) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].test(input)) continue;
            return this.iTransformers[i].apply(input);
        }
        return this.iDefault.apply(input);
    }
}

