/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.alg.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.experimental.alg.ApproximationAlgorithm;
import org.apache.storm.shade.org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class GreedyColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ApproximationAlgorithm<Integer, V> {
    public static final int BEST_ORDER = 0;
    public static final int NATURAL_ORDER = 1;
    public static final int SMALLEST_DEGREE_LAST_ORDER = 2;
    public static final int LARGEST_SATURATION_FIRST_ORDER = 3;
    private int _order = 0;

    public GreedyColoring(Graph<V, E> g) {
        this(g, 0);
    }

    public GreedyColoring(Graph<V, E> g, int method) {
        super(g);
        this._order = method;
    }

    int color(int[] order) {
        int[] color = new int[this._neighbors.length];
        int maxColor = 1;
        BitSet usedColors = new BitSet(this._neighbors.length);
        for (int i = 0; i < this._neighbors.length; ++i) {
            int v = order == null ? i : order[i];
            usedColors.clear();
            for (int j = 0; j < this._neighbors[v].length; ++j) {
                int nb = this._neighbors[v][j];
                if (color[nb] <= 0) continue;
                usedColors.set(color[nb]);
            }
            color[v] = usedColors.nextClearBit(1);
            if (color[v] <= maxColor) continue;
            maxColor = color[v];
        }
        return maxColor;
    }

    int[] smallestDegreeLastOrder() {
        int i;
        int[] order = new int[this._neighbors.length];
        int[] degree = new int[this._neighbors.length];
        ArrayList buckets = new ArrayList(this._neighbors.length);
        int index = this._neighbors.length - 1;
        for (i = 0; i < this._neighbors.length; ++i) {
            buckets.add(new ArrayList());
            degree[i] = this._neighbors[i].length;
        }
        for (i = 0; i < this._neighbors.length; ++i) {
            ((List)buckets.get(degree[i])).add(i);
        }
        for (i = 0; i < this._neighbors.length; ++i) {
            while (((List)buckets.get(i)).size() > 0) {
                int s = ((List)buckets.get(i)).size() - 1;
                int vertex = (Integer)((List)buckets.get(i)).get(s);
                ((List)buckets.get(i)).remove(s);
                degree[vertex] = -1;
                order[index--] = vertex;
                for (int j = 0; j < this._neighbors[vertex].length; ++j) {
                    int nb = this._neighbors[vertex][j];
                    if (degree[nb] < 0) continue;
                    ((List)buckets.get(degree[nb])).remove(new Integer(nb));
                    int n = nb;
                    degree[n] = degree[n] - 1;
                    ((List)buckets.get(degree[nb])).add(nb);
                    if (degree[nb] >= i) continue;
                    i = degree[nb];
                }
            }
        }
        return order;
    }

    int[] largestSaturationFirstOrder() {
        int[] satur = new int[this._neighbors.length];
        int[] buckets = new int[this._neighbors.length];
        int[] cumBucketSize = new int[this._neighbors.length];
        int[] bucketIndex = new int[this._neighbors.length];
        int index = 0;
        int maxSat = 0;
        for (int i = 0; i < this._neighbors.length; ++i) {
            buckets[i] = i;
            bucketIndex[i] = i;
        }
        cumBucketSize[0] = this._neighbors.length;
        while (index < this._neighbors.length) {
            while (maxSat > 0 && cumBucketSize[maxSat] == cumBucketSize[maxSat - 1]) {
                cumBucketSize[maxSat--] = 0;
            }
            int v = buckets[cumBucketSize[maxSat] - 1];
            int n = maxSat;
            cumBucketSize[n] = cumBucketSize[n] - 1;
            satur[v] = -1;
            ++index;
            for (int j = 0; j < this._neighbors[v].length; ++j) {
                int nb = this._neighbors[v][j];
                int bi = bucketIndex[nb];
                if (satur[nb] < 0) continue;
                if (bi != cumBucketSize[satur[nb]] - 1) {
                    buckets[bi] = buckets[cumBucketSize[satur[nb]] - 1];
                    buckets[cumBucketSize[satur[nb]] - 1] = nb;
                    bucketIndex[nb] = cumBucketSize[satur[nb]] - 1;
                    bucketIndex[buckets[bi]] = bi;
                }
                int n2 = satur[nb];
                cumBucketSize[n2] = cumBucketSize[n2] - 1;
                int n3 = nb;
                satur[n3] = satur[n3] + 1;
                if (cumBucketSize[satur[nb]] == 0) {
                    cumBucketSize[satur[nb]] = cumBucketSize[satur[nb] - 1] + 1;
                }
                if (satur[nb] <= maxSat) continue;
                maxSat = satur[nb];
            }
        }
        Collections.reverse(Arrays.asList(new int[][]{buckets}));
        return buckets;
    }

    @Override
    public Integer getLowerBound(Map<V, Object> optionalData) {
        return 0;
    }

    @Override
    public Integer getUpperBound(Map<V, Object> optionalData) {
        switch (this._order) {
            case 0: {
                return Math.min(Math.min(this.color(null), this.color(this.smallestDegreeLastOrder())), this.color(this.largestSaturationFirstOrder()));
            }
            case 1: {
                return this.color(null);
            }
            case 2: {
                return this.color(this.smallestDegreeLastOrder());
            }
            case 3: {
                return this.color(this.largestSaturationFirstOrder());
            }
        }
        return this._neighbors.length;
    }

    @Override
    public boolean isExact() {
        return false;
    }
}

