/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseBasicBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWordCounter
extends BaseBasicBolt {
    public static Logger LOG = LoggerFactory.getLogger(TestWordCounter.class);
    Map<String, Integer> counts;

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context) {
        this.counts = new HashMap<String, Integer>();
    }

    protected String getTupleValue(Tuple t, int idx) {
        return (String)t.getValues().get(idx);
    }

    @Override
    public void execute(Tuple input, BasicOutputCollector collector) {
        String word = this.getTupleValue(input, 0);
        int count = 0;
        if (this.counts.containsKey(word)) {
            count = this.counts.get(word);
        }
        this.counts.put(word, ++count);
        collector.emit(Utils.tuple(word, count));
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("word", "count"));
    }
}

