/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.testing.AckFailDelegate;

public class AckTracker
implements AckFailDelegate {
    private static Map<String, AtomicInteger> acks = new ConcurrentHashMap<String, AtomicInteger>();
    private String id = UUID.randomUUID().toString();

    public AckTracker() {
        acks.put(this.id, new AtomicInteger(0));
    }

    @Override
    public void ack(Object id) {
        acks.get(this.id).incrementAndGet();
    }

    @Override
    public void fail(Object id) {
    }

    public int getNumAcks() {
        return acks.get(this.id).intValue();
    }

    public void resetNumAcks() {
        acks.get(this.id).set(0);
    }
}

