/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty.setup;

import io.dropwizard.jetty.MutableServletContextHandler;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRegistration;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletEnvironment.class);
    private final MutableServletContextHandler handler;
    private final Set<String> servlets = new HashSet<String>();
    private final Set<String> filters = new HashSet<String>();

    public ServletEnvironment(MutableServletContextHandler handler) {
        this.handler = handler;
    }

    public ServletRegistration.Dynamic addServlet(String name, Servlet servlet) {
        ServletHolder holder = new ServletHolder(name, servlet);
        ServletHandler servletHandler = this.handler.getServletHandler();
        servletHandler.addServlet(holder);
        ServletHolder.Registration registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.servlets, "servlet");
        return registration;
    }

    public ServletRegistration.Dynamic addServlet(String name, Class<? extends Servlet> klass) {
        ServletHolder holder = new ServletHolder(name, klass);
        ServletHandler servletHandler = this.handler.getServletHandler();
        servletHandler.addServlet(holder);
        ServletHolder.Registration registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.servlets, "servlet");
        return registration;
    }

    public FilterRegistration.Dynamic addFilter(String name, Filter filter) {
        return this.addFilter(name, new FilterHolder(Objects.requireNonNull(filter)));
    }

    public FilterRegistration.Dynamic addFilter(String name, Class<? extends Filter> klass) {
        return this.addFilter(name, new FilterHolder(Objects.requireNonNull(klass)));
    }

    private FilterRegistration.Dynamic addFilter(String name, FilterHolder holder) {
        holder.setName(name);
        this.handler.getServletHandler().addFilter(holder);
        FilterRegistration.Dynamic registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.filters, "filter");
        return registration;
    }

    public void addServletListeners(EventListener ... listeners) {
        for (EventListener listener : listeners) {
            this.handler.addEventListener(listener);
        }
    }

    public void setProtectedTargets(String ... targets) {
        this.handler.setProtectedTargets(Arrays.copyOf(targets, targets.length));
    }

    public void setBaseResource(Resource baseResource) {
        this.handler.setBaseResource(baseResource);
    }

    public void setBaseResource(Resource ... baseResources) {
        this.handler.setBaseResource(ResourceFactory.combine((Resource[])baseResources));
    }

    public void setBaseResource(String ... resources) {
        this.handler.setBaseResource(ResourceFactory.combine(Arrays.stream(resources).map(arg_0 -> ((MutableServletContextHandler)this.handler).newResource(arg_0)).toList()));
    }

    public void setResourceBase(String resourceBase) {
        this.handler.setBaseResource(this.handler.newResource(resourceBase));
    }

    public void setInitParameter(String name, String value) {
        this.handler.setInitParameter(name, value);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.handler.setSessionsEnabled(sessionHandler != null);
        this.handler.setSessionHandler(sessionHandler);
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.handler.setSecurityEnabled(securityHandler != null);
        this.handler.setSecurityHandler(securityHandler);
    }

    public void addMimeMapping(String extension, String type) {
        this.handler.getMimeTypes().addMimeMapping(extension, type);
    }

    private void checkDuplicateRegistration(String name, Set<String> items, String type) {
        if (!items.add(name)) {
            LOGGER.warn("Overriding the existing {} registered with the name: {}", (Object)type, (Object)name);
        }
    }
}

