/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ConnectionConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionConfiguration.class);
    public static final String WRITE_BUFFER_SIZE_KEY = "hbase.client.write.buffer";
    public static final long WRITE_BUFFER_SIZE_DEFAULT = 0x200000L;
    public static final String WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS = "hbase.client.write.buffer.periodicflush.timeout.ms";
    public static final String WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS = "hbase.client.write.buffer.periodicflush.timertick.ms";
    public static final long WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS_DEFAULT = 0L;
    public static final long WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS_DEFAULT = 1000L;
    public static final String MAX_KEYVALUE_SIZE_KEY = "hbase.client.keyvalue.maxsize";
    public static final int MAX_KEYVALUE_SIZE_DEFAULT = 0xA00000;
    public static final String BUFFERED_MUTATOR_MAX_MUTATIONS_KEY = "hbase.client.write.buffer.maxmutations";
    public static final int BUFFERED_MUTATOR_MAX_MUTATIONS_DEFAULT = -1;
    public static final String PRIMARY_CALL_TIMEOUT_MICROSECOND = "hbase.client.primaryCallTimeout.get";
    public static final int PRIMARY_CALL_TIMEOUT_MICROSECOND_DEFAULT = 10000;
    public static final String PRIMARY_SCAN_TIMEOUT_MICROSECOND = "hbase.client.replicaCallTimeout.scan";
    public static final int PRIMARY_SCAN_TIMEOUT_MICROSECOND_DEFAULT = 1000000;
    public static final String HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED = "hbase.client.pause.server.overloaded";
    public static final String HBASE_CLIENT_META_READ_RPC_TIMEOUT_KEY = "hbase.client.meta.read.rpc.timeout";
    public static final String HBASE_CLIENT_META_SCANNER_TIMEOUT = "hbase.client.meta.scanner.timeout.period";
    public static final String HBASE_CLIENT_USE_SCANNER_TIMEOUT_PERIOD_FOR_NEXT_CALLS = "hbase.client.use.scanner.timeout.period.for.next.calls";
    public static final boolean HBASE_CLIENT_USE_SCANNER_TIMEOUT_PERIOD_FOR_NEXT_CALLS_DEFAULT = false;
    private final long writeBufferSize;
    private final long writeBufferPeriodicFlushTimeoutMs;
    private final long writeBufferPeriodicFlushTimerTickMs;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int primaryCallTimeoutMicroSecond;
    private final int replicaCallTimeoutMicroSecondScan;
    private final int metaReplicaCallTimeoutMicroSecondScan;
    private final int retries;
    private final int maxKeyValueSize;
    private final int bufferedMutatorMaxMutations;
    private final int rpcTimeout;
    private final int readRpcTimeout;
    private final int metaReadRpcTimeout;
    private final int writeRpcTimeout;
    private final int scanTimeout;
    private final int metaScanTimeout;
    private final boolean clientScannerAsyncPrefetch;
    private final long pauseMs;
    private final long pauseMsForServerOverloaded;
    private final boolean useScannerTimeoutForNextCalls;

    ConnectionConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong(WRITE_BUFFER_SIZE_KEY, 0x200000L);
        this.writeBufferPeriodicFlushTimeoutMs = conf.getLong(WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS, 0L);
        this.writeBufferPeriodicFlushTimerTickMs = conf.getLong(WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS, 1000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.primaryCallTimeoutMicroSecond = conf.getInt(PRIMARY_CALL_TIMEOUT_MICROSECOND, 10000);
        this.replicaCallTimeoutMicroSecondScan = conf.getInt(PRIMARY_SCAN_TIMEOUT_MICROSECOND, 1000000);
        this.metaReplicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.meta.replica.scan.timeout", 1000000);
        this.retries = conf.getInt("hbase.client.retries.number", 15);
        this.clientScannerAsyncPrefetch = conf.getBoolean("hbase.client.scanner.async.prefetch", false);
        this.maxKeyValueSize = conf.getInt(MAX_KEYVALUE_SIZE_KEY, 0xA00000);
        this.bufferedMutatorMaxMutations = conf.getInt(BUFFERED_MUTATOR_MAX_MUTATIONS_KEY, -1);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.readRpcTimeout = conf.getInt("hbase.rpc.read.timeout", conf.getInt("hbase.rpc.timeout", 60000));
        this.metaReadRpcTimeout = conf.getInt(HBASE_CLIENT_META_READ_RPC_TIMEOUT_KEY, this.readRpcTimeout);
        this.writeRpcTimeout = conf.getInt("hbase.rpc.write.timeout", conf.getInt("hbase.rpc.timeout", 60000));
        this.scanTimeout = conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.metaScanTimeout = conf.getInt(HBASE_CLIENT_META_SCANNER_TIMEOUT, this.scanTimeout);
        this.useScannerTimeoutForNextCalls = conf.getBoolean(HBASE_CLIENT_USE_SCANNER_TIMEOUT_PERIOD_FOR_NEXT_CALLS, false);
        long pauseMs = conf.getLong("hbase.client.pause", 100L);
        long pauseMsForServerOverloaded = conf.getLong(HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED, conf.getLong("hbase.client.pause.cqtbe", pauseMs));
        if (pauseMsForServerOverloaded < pauseMs) {
            LOG.warn("The {} setting: {} ms is less than the {} setting: {} ms, use the greater one instead", new Object[]{HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED, pauseMsForServerOverloaded, "hbase.client.pause", pauseMs});
            pauseMsForServerOverloaded = pauseMs;
        }
        this.pauseMs = pauseMs;
        this.pauseMsForServerOverloaded = pauseMsForServerOverloaded;
    }

    protected ConnectionConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.writeBufferPeriodicFlushTimeoutMs = 0L;
        this.writeBufferPeriodicFlushTimerTickMs = 1000L;
        this.metaOperationTimeout = 1200000;
        this.operationTimeout = 1200000;
        this.scannerCaching = Integer.MAX_VALUE;
        this.scannerMaxResultSize = 0x200000L;
        this.primaryCallTimeoutMicroSecond = 10000;
        this.replicaCallTimeoutMicroSecondScan = 1000000;
        this.metaReplicaCallTimeoutMicroSecondScan = 1000000;
        this.retries = 15;
        this.clientScannerAsyncPrefetch = false;
        this.maxKeyValueSize = 0xA00000;
        this.bufferedMutatorMaxMutations = -1;
        this.readRpcTimeout = 60000;
        this.metaReadRpcTimeout = 60000;
        this.writeRpcTimeout = 60000;
        this.rpcTimeout = 60000;
        this.metaScanTimeout = this.scanTimeout = 60000;
        this.pauseMs = 100L;
        this.pauseMsForServerOverloaded = 100L;
        this.useScannerTimeoutForNextCalls = false;
    }

    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    public int getMetaReadRpcTimeout() {
        return this.metaReadRpcTimeout;
    }

    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public long getWriteBufferPeriodicFlushTimeoutMs() {
        return this.writeBufferPeriodicFlushTimeoutMs;
    }

    public long getWriteBufferPeriodicFlushTimerTickMs() {
        return this.writeBufferPeriodicFlushTimerTickMs;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getPrimaryCallTimeoutMicroSecond() {
        return this.primaryCallTimeoutMicroSecond;
    }

    public int getReplicaCallTimeoutMicroSecondScan() {
        return this.replicaCallTimeoutMicroSecondScan;
    }

    public int getMetaReplicaCallTimeoutMicroSecondScan() {
        return this.metaReplicaCallTimeoutMicroSecondScan;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public int getBufferedMutatorMaxMutations() {
        return this.bufferedMutatorMaxMutations;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    public boolean isClientScannerAsyncPrefetch() {
        return this.clientScannerAsyncPrefetch;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public int getScanTimeout() {
        return this.scanTimeout;
    }

    public boolean isUseScannerTimeoutForNextCalls() {
        return this.useScannerTimeoutForNextCalls;
    }

    public int getMetaScanTimeout() {
        return this.metaScanTimeout;
    }

    public long getPauseMillis() {
        return this.pauseMs;
    }

    public long getPauseMillisForServerOverloaded() {
        return this.pauseMsForServerOverloaded;
    }

    static {
        Configuration.addDeprecation((String)"hbase.client.pause.cqtbe", (String)HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED);
    }
}

